﻿/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (“GENESYS”) “AS IS” WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;
using System.Text;
using GISServices;

/*This example demonstrates how to subscribe to a GIS Statistic service.
 */

public class ConnectSessionServiceExample
{
    public SessionServiceService port;
    public String sid;
    public String[] services = new String[1] { "GIS_STATSERVICE" };

    /*
     * this method uses CreateSessionExample to log onto GIS server and
     * retrieve a session.
     * Then it request a subscription to the GIS stat service.
     */

    public void execute(String targetHost)
    {
        CreateSessionExample sess = new CreateSessionExample();
        sess.execute(targetHost);
        port = sess.port;
        sid = sess.sid;
        String[] list_subscribed = port.getServices(services);
        System.Console.WriteLine("Number of services subscribed = " + list_subscribed.Length);
        foreach (String service in list_subscribed)
            System.Console.WriteLine("Service subscribed = " + service);
    }
}


