/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;

/* This example demonstrates how to browse services available,
 * release services, and logout session 
 */

public class IdentifyServicesExample
{

    /* 
     * This method uses the ConnectToServiceExample to login and subscribe to a service.
     * Then it browses the services available, releases those services and finally log out of the session
     *
     */

    public void execute(String targetHost)
    {
        ConnectSessionServiceExample cs = new ConnectSessionServiceExample();
        cs.execute(targetHost);

        //we ask for licenses checked
        String[] licenses_checked = cs.port.browseServices();
        foreach (String service in licenses_checked)
            System.Console.WriteLine("browsing services available:  " + service);

        //we release the licenses checked
        System.Console.WriteLine("releasing services...");
        String[] licenses_released = cs.port.releaseServices(cs.services);
        foreach (String service in licenses_released)
            System.Console.WriteLine("Services released:  " + service);
        cs.port.logout(cs.sid);	//logout request
        System.Console.WriteLine("logout from session");
    }
}
