/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;
using GISServices;

/*
 * This example demonstrates how to subscribe and retrieve a statistic using the solicited
 * notification - Polling mode.
 * 
 * In this example the object of interest is an agent, the statistic retrieved is the total login time
 * for that agent.
 * We are also assuming the agent object is under the Tenant "defaultTenant" in Configuration Management.
 * 
 * This example can be slightly modified to retrieve statistics for agent, queue, place, etc
 * See the statistic SDK documentation for details.
 * 
 */

public class RetrieveSubscribedStatisticExample
{

    /*
     * this method retrieves the subscribed statistic using the polling notification mode.
     * The code uses the SubscribeToStatisticExample to establish a session and 
     * subscription to the statistic Total_Login_Time, as specified in SubscribeToStatisticExample.
     * 
     */

    public void execute(String targetHost)
    {
        SubscribeToStatisticExample sb = new SubscribeToStatisticExample();
        sb.execute(targetHost);
        //Retrieve subscribed statistic
        statisticSubscriptions subscriptions = new statisticSubscriptions();

        statisticSubscription subscription = new statisticSubscription();
        subscription.scope = "all";
        subscription.statisticId = "statref1";
        statisticSubscription[] array_subscriptions = new statisticSubscription[1];
        array_subscriptions.SetValue(subscription, 0);
        subscriptions.statisticSubscription = array_subscriptions;

        //specify notification. Here the polling mode is used
        notification notif = new notification();
        notif.mode = notificationMode.Polling;
        notif.timeout = "10";
        retrieveSubscribedStatisticsResponse response = sb.port_stat.retrieveSubscribedStatistics(subscriptions, notif);

        //returns the value
        statisticValue val = (statisticValue)response.statisticValues.GetValue(0);
        System.Console.WriteLine("Retrieved statistic value = " + ((eventValue)val.eventValues.GetValue(0)).LValue);
    }
}
