/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2007-2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

using System;

namespace Tests
{
	class TestSuite
	{
	
		#region Test1: Create Session Example
		public void executeTest1()
		{
			System.Console.WriteLine("\n Test 1");
			CreateSessionExample example = new CreateSessionExample();
			example.execute("localhost:8080");
		}
		#endregion

		#region Test2: Connect Session Service Example
		public void executeTest2()
		{
			System.Console.WriteLine("\n Test 2");
			ConnectSessionServiceExample example = new ConnectSessionServiceExample();
			example.execute("localhost:8080");
		}
		#endregion

		#region Test3: Identify Services Example
		public void executeTest3()
		{
			System.Console.WriteLine("\n Test 3");
			IdentifyServicesExample example = new IdentifyServicesExample();
			example.execute("localhost:8080");
		}
		#endregion

		#region Test4: Retrieve Statistical Profile Example
		public void executeTest4()
		{
			System.Console.WriteLine("\n Test 4");
			RetrieveStatisticalProfileExample example = new RetrieveStatisticalProfileExample();
			example.execute("localhost:8080");
		}
		#endregion

		#region Test5: Retrieve Statistic Example
		public void executeTest5()
		{
			System.Console.WriteLine("\n Test 5");
			RetrieveStatisticExample retstat = new RetrieveStatisticExample();
			retstat.execute("localhost:8080");
		}
		#endregion

		#region Test6: Subscribe To Statistic Example
		public void executeTest6()
		{
			System.Console.WriteLine("\n Test 6");
			SubscribeToStatisticExample example = new SubscribeToStatisticExample();
			example.execute("localhost:8080");
			example.unsubscribe();
		}
		#endregion

		#region Test7: Retrieve Subscribed Statistic Example
		public void executeTest7()
		{
			System.Console.WriteLine("\n Test 7");
			RetrieveSubscribedStatisticExample example = new RetrieveSubscribedStatisticExample();
			example.execute("localhost:8080");
		}
		#endregion

		#region Test8: Unsolicited Notification Example
		public void executeTest8()
		{
			System.Console.WriteLine("\n Test 8");
			UnsolicitedNotificationExample example = new UnsolicitedNotificationExample();
			example.execute("localhost:8080");
		}
		#endregion

		[STAThread]
		static void Main(string[] args)
		{
			TestSuite tests = new TestSuite();

			tests.executeTest1();

			System.Console.WriteLine("Press a <Enter> to continue...");
			System.Console.ReadLine();

			tests.executeTest2();
			System.Console.WriteLine("Press a <Enter> to continue...");
			System.Console.ReadLine();

			tests.executeTest3();
			System.Console.WriteLine("Press a <Enter> to continue...");
			System.Console.ReadLine();
			
			tests.executeTest4();
			System.Console.WriteLine("Press a <Enter> to continue...");
			System.Console.ReadLine();

			tests.executeTest5();
			System.Console.WriteLine("Press a <Enter> to continue...");
			System.Console.ReadLine();

			tests.executeTest6();
			System.Console.WriteLine("Press a <Enter> to continue...");
			System.Console.ReadLine();

			tests.executeTest7();
			System.Console.WriteLine("Press a <Enter> to continue...");
			System.Console.ReadLine();
			
			tests.executeTest8();
		}
	}
}
