/*=====================================================================

Any authorized distribution of any copy of this code (including any related documentation) must reproduce the following restrictions, disclaimer and copyright notice:

The Genesys name, trademarks and/or logo(s) of Genesys shall not be used to name (even as a part of another name), endorse and/or promote products derived from this code without prior written permission from Genesys Telecommunications Laboratories, Inc.

The use, copy, and/or distribution of this code is subject to the terms of the Genesys Developer License Agreement.  This code shall not be used, copied, and/or distributed under any other license agreement.

THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES, INC. (GENESYS) AS IS WITHOUT ANY WARRANTY OF ANY KIND. GENESYS HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS, REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT, CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).

Copyright &copy; 2008 Genesys Telecommunications Laboratories, Inc. All rights reserved.

=====================================================================*/

package com.genesyslab.gis.services.statistic;

import com.genesyslab.gis.services.session.ConnectSessionServiceExample;
import com.genesyslab.gis.services.statistic.types.Metric;
import com.genesyslab.gis.services.statistic.types.ObjectIdType;
import com.genesyslab.gis.services.statistic.types.ObjectType;
import com.genesyslab.gis.services.statistic.types.Schedule;
import com.genesyslab.gis.services.statistic.types.ScheduleMode;
import com.genesyslab.gis.services.statistic.types.Statistic;
import com.genesyslab.gis.services.statistic.types.StatisticType;
import com.genesyslab.gis.services.statistic.types.TimeInterval;
import com.genesyslab.gis.services.statistic.types.TimeIntervalType;
import com.genesyslab.gis.services.statistic.types.UnsolicitedNotification;
import com.genesyslab.gis.util.NotificationModule;
import com.genesyslab.gis.util.PropertiesLoader;

/**
 * This examples demonstrates how to make a unsolicitedNotification request. To
 * use this notification mode, client side must have a web server that
 * implements the notification.wsdl. See the example NotifyService.java.
 * 
 * Date: June, 2008
 * 
 */

public class UnsolicitedNotificationExample {

	StatService statPort;
	ConnectSessionServiceExample cs;

	public UnsolicitedNotificationExample() {
	}

	/*
	 * This method is almost identical to SubscribeToStatistic.java The
	 * exception is that in SubscribeToStatistic.java, the
	 * UnsolicitedNotification object is not populated. In this example, a
	 * client web server's host and port information is set in the
	 * UnsolicitedNotification object and passed along with a statistic
	 * subscription request.
	 * 
	 * @param gisServer <gis_host>:<gis_port>
	 */

	public void execute(String gisServer) throws Exception {

		String[] services = { "GIS_STATSERVICE" };

		// ----------------------------------------------------------------------------//
		// This section is similar to the execute() method in
		// SubscribeToStatistic.java
		// ----------------------------------------------------------------------------//

		// first step is to connect to a service. See
		// ConnectToServiceExample.java.
		cs = new ConnectSessionServiceExample(services);
		cs.execute(gisServer);

		// Make a service
		StatServiceServiceLocator statService = new StatServiceServiceLocator();

		// Now use the service to get a stub which implements the SDI.
		statPort = statService.getStatService(new java.net.URL("http://"
				+ gisServer + "/gis/services/StatService?GISsessionId="
				+ cs.sid));

		// build a statistic object
		Statistic statistic = new Statistic();
		statistic.setStatisticId("statref1");

		// build an ObjectIdType object
		ObjectIdType objectId = new ObjectIdType();
		String agentId = PropertiesLoader.getOption("statistic.agentId");
		System.out.println("Statistic needed for " + agentId);
		// enter the employee id for this method
		objectId.setId(agentId);
		// The agent object is under the Tenant statistic.tenant. Note
		// statistic.tenant is the tenant name
		// defined in gis.properties file
		String tenant = PropertiesLoader.getOption("statistic.tenant");
		objectId.setTenantName(tenant);

		// adding object id data to statistic
		statistic.setObjectId(objectId);

		// building metric data
		Metric metric = new Metric();
		StatisticType statisticType = new StatisticType();
		ObjectType[] objectType = new ObjectType[] { ObjectType.Agent };
		statisticType.setObjectType(objectType);
		metric.setStatisticType(statisticType);
		System.out
				.println("Statistic of interest is the agent's total login time");
		metric.setTypeName("TotalLoginTime");
		TimeInterval timeInterval = new TimeInterval();
		timeInterval.setIntervalType(TimeIntervalType.GrowingWindow);
		metric.setInterval(timeInterval);

		// adding metric data to statistic
		statistic.setMetric(metric);

		// specify statistic schedule
		Schedule schedule = new Schedule();
		schedule.setNotificationMode(ScheduleMode.ChangesBased);
		statistic.setSchedule(schedule);

		// -------------------------------------------------------------------------------//

		//
		// create an unsolicitedNotification object and pass in the listening
		// client server's notification service url. The client server must
		// implement the service according to GIS's notification.wsdl
		// specification.
		//
		String gisHost = PropertiesLoader.getOption("gis.host");
		String notificationPort = PropertiesLoader
				.getOption("client.notification.port");
		UnsolicitedNotification un = new UnsolicitedNotification();
		// url points to your client http server's notification service
		un.setUrl("http://" + gisHost + ":" + notificationPort
				+ "/axis/services/notification"); // this
		
		
		// Subscribe to the statistic. Note statistic.statserver.name is the
		// application name
		// of a particular stat server defined in gis.properties file
		String statServeName = PropertiesLoader
				.getOption("statistic.statserver.name");

		
		NotificationModule.getInstance().start();
		
		// subscribe request using the UnsolicitedNotification mode
		statPort.subscribeStatistic(statistic, statServeName, un); // after
		// the client app waits for updates
		System.out.println("Waiting for statistic from GIS server...\n");

	}

	// Standalone option to test run this example. Creates a new instance
	// of this object and starts the process.
	public static void main(String[] args) {
		String gisHost = PropertiesLoader.getOption("gis.host");
		String gisPort = PropertiesLoader.getOption("gis.port");
		try {
			UnsolicitedNotificationExample example = new UnsolicitedNotificationExample();
			example.execute(gisHost + ":" + gisPort);

		} catch (Exception serviceException) {
			System.out.println(serviceException.getMessage());
		}
	}
}