/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/

/*
 * This example is as accurate and complete as possible.
 * However, it is not intended to be more than a model for
 * development. It cannot be combined with other examples
 * to form a fully-functional client application. Genesys
 * does not guarantee the performance of this example or
 * provide support for it.
 */

package gis.sessExamples;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import javax.xml.namespace.QName;
import gis.services.session.*;

/*
 * This example demonstrates how to check out a license for a GIS Statistic service.
 *
 * @date: March 25, 2003
 */

 public class ConnectToServiceExample {

    public gis.services.session.SessionService port;
    public String sid;
    public String[] services;
    public String gisServer;           //keeps track of this info for other classes

    public ConnectToServiceExample(String[] gisServices){
	services = gisServices;
    }

  /*
   * This method uses the CreateSessionExample to log into GIS server and retrieve a session.
   * Then it checks out a license for the GIS stat services.
   */

    public void execute(String gisServer)throws Exception{

    	CreateSessionExample sess = new CreateSessionExample();
        sess.loginAndCreateSession(gisServer);
        port = sess.port;
        sid = sess.sid;
        gisServer = gisServer;

	String[] list_subscribed = port.getServices(services);
        System.out.println("Number of services checked out = "+ list_subscribed.length);
        for(int i=0;i<list_subscribed.length;i++){
          System.out.println("Service checked out = " + list_subscribed[i]);
        }
    }

    /*
     * Standalone option to test run this example. Creates a new instance of this object and starts the process
     *
     * @param args0 	The service to invoke. 'GIS_STATSERVICE' or 'GIS_CONFIGSERVICE.
     * 			Input must be a string array e.g {"GIS_STATSERVICE"} or {"GIS_STATSERVICE","GIS_CONFIGSERVICE"}
     *
     * E.g. java gis.sessExamples.ConnectToServiceExample GIS_STATSERVICE
     */

    public static void main(String[] args) {

       try{
          ConnectToServiceExample cs = new ConnectToServiceExample(args);
          cs.execute("localhost:9090");
       }catch (Exception serviceException) {
           System.out.println(serviceException.getMessage());
       }
    }
}
