/*=====================================================================
 * Any authorized distribution of any copy of this code (including any
 * related documentation) must reproduce the following restrictions,
 * disclaimer and copyright notice:
 *
 * The Genesys name, the trademarks and/or logo(s) of Genesys shall
 * not be used to name (even as a part of another name), endorse and/or
 * promote products derived from this code without prior written
 * permission from Genesys Telecommunications Laboratories, Inc.
 *
 * The use, copy, and/or distribution of this code is subject to the
 * terms of the Genesys Developer License Agreement.  This code shall
 * not be used, copied, and/or distributed under any other license
 * agreement.
 *
 * THIS CODE IS PROVIDED BY GENESYS TELECOMMUNICATIONS LABORATORIES,
 * INC. ("GENESYS") "AS IS" WITHOUT ANY WARRANTY OF ANY KIND. GENESYS
 * HEREBY DISCLAIMS ALL EXPRESS, IMPLIED, OR STATUTORY CONDITIONS,
 * REPRESENTATIONS AND WARRANTIES WITH RESPECT TO THIS CODE (OR ANY
 * PART THEREOF), INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NON-INFRINGEMENT. GENESYS AND ITS SUPPLIERS SHALL NOT BE LIABLE FOR
 * ANY DAMAGE SUFFERED AS A RESULT OF USING THIS CODE. IN NO EVENT
 * SHALL GENESYS AND ITS SUPPLIERS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * CONSEQUENTIAL, ECONOMIC, INCIDENTAL, OR SPECIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, ANY LOST REVENUES OR PROFITS).
 *
 * Copyright (C) 2006-2008 Genesys Telecommunications Laboratories,
 * Inc. All rights reserved.
 =====================================================================*/

/*
 * This example is as accurate and complete as possible.
 * However, it is not intended to be more than a model for
 * development. It cannot be combined with other examples
 * to form a fully-functional client application. Genesys
 * does not guarantee the performance of this example or
 * provide support for it.
 */

package gis.statExamples;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

import javax.xml.namespace.QName;

import gis.sessExamples.*;
import gis.services.statistic.*;


/*
 * This example demonstrates how to retrieve a subscribed statistic using
 * the solicited notification - Polling mode.
 *
 * In this example the object of interest is an agent.
 * The statistic retrieved is the total login time for that agent.
 * We are also assuming the agent object is under the Tenant 'Resources' in Configuration Management.
 *
 * This example can be slightly modified to retrieve statistics for retrieving queues, places, etc.
 * See the Statistic SDK documentation for details.
 *
 * @Date: March 25, 2003
 */

public class RetrieveSubscribedStatisticExample {

    public RetrieveSubscribedStatisticExample() {}

/*
 * This method retrieves the subscribed statistic using the polling notification mode.
 * The code uses the SubscribeToStatistic example to establish a session and
 * subscription to the statistic - Total_Login_Time, as specified in SubscribeToStatistic example.
 *
 * @param gisServer <gisHost>:<gisPort>
 */
    public void execute(String gisServer)throws Exception{

	//we don't need to pass in {"GIS_STATSERVICE"}. The SubscribeToStatisticExample class did it.
  	SubscribeToStatisticExample sb = new SubscribeToStatisticExample();
        sb.subscribe(gisServer);

        //Retrieve subscribed statistic
        gis.services.statistic.StatisticSubscriptions subscriptions = new gis.services.statistic.StatisticSubscriptions();
        gis.services.statistic.StatisticSubscription subscription = new gis.services.statistic.StatisticSubscription();
        subscription.setScope("all");
        subscription.setStatisticId("statref1");
        subscriptions.setStatisticSubscription(new gis.services.statistic.StatisticSubscription[]{subscription});

        //specify notification. This code uses the polling mode.
        gis.services.statistic.Notification notification = new gis.services.statistic.Notification();
        notification.setMode(gis.services.statistic.NotificationMode.Polling);
        notification.setTimeout(new java.math.BigInteger("10"));
        gis.services.statistic.RetrieveSubscribedStatisticsResponse response = sb.statPort.retrieveSubscribedStatistics(subscriptions, notification);
        //returns the value
        System.out.println("Retrieved statistic value = "+ ((EventValue)((StatisticValue)response.getStatisticValues()[0]).getEventValues()[0]).getLValue());
    }

    	//Standalone option to test run this example.
	//Creates a new instance of this object and starts the process.
    public static void main(String[] args) {

       try{
          RetrieveSubscribedStatisticExample subret = new RetrieveSubscribedStatisticExample();
          subret.execute("localhost:9090");
       } catch (Exception serviceException) {
          System.out.println(serviceException.getMessage());
       }
    }
}