/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.commons;

import com.genesyslab.platform.applicationblocks.commons.Predicate;
import com.genesyslab.platform.applicationblocks.commons.PredicateBase;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositePredicateBase<T>
extends PredicateBase<T> {
    private ArrayList<Predicate<T>> predicates = new ArrayList();

    protected CompositePredicateBase() {
    }

    protected CompositePredicateBase(boolean isNegated) {
        super(isNegated);
    }

    protected CompositePredicateBase(Predicate<T> p0, Predicate<T> p1) {
        this.addPredicate(p0);
        this.addPredicate(p1);
    }

    protected ArrayList<Predicate<T>> getPredicates() {
        return this.predicates;
    }

    public void addPredicate(Predicate<T> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is null.");
        }
        if (this.predicates.contains(predicate)) {
            throw new IllegalArgumentException("predicate was already added.");
        }
        this.predicates.add(predicate);
    }

    public void removePredicate(Predicate<T> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is null.");
        }
        if (!this.predicates.contains(predicate)) {
            throw new IllegalArgumentException("predicate was not added.");
        }
        this.predicates.remove(predicate);
    }
}

