/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.commons.broker;

import com.genesyslab.platform.applicationblocks.commons.broker.MessageFilter;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import java.util.Arrays;

public class MessageRangeFilter
extends MessageFilter {
    private int[] messages;

    public MessageRangeFilter(int[] messagesRange) {
        this.validate(messagesRange);
        this.initialize(messagesRange);
    }

    public MessageRangeFilter(boolean isNegated, int[] messagesRange) {
        super(isNegated);
        this.validate(messagesRange);
        this.initialize(messagesRange);
    }

    public MessageRangeFilter(ProtocolDescription protocolDescription, int[] messagesRange) {
        super(protocolDescription);
        this.validate(messagesRange);
        this.initialize(messagesRange);
    }

    public MessageRangeFilter(boolean isNegated, ProtocolDescription protocolDescription, int[] messagesRange) {
        super(isNegated, protocolDescription);
        this.validate(messagesRange);
        this.initialize(messagesRange);
    }

    public int[] getMessagesRange() {
        return this.messages;
    }

    public void setMessagesRange(int[] messagesRange) {
        this.validate(messagesRange);
        this.initialize(messagesRange);
    }

    protected boolean evaluate(Message message) {
        if (!super.evaluate(message)) {
            return false;
        }
        return Arrays.binarySearch(this.messages, message.messageId()) >= 0;
    }

    private void validate(int[] messagesRange) {
        if (messagesRange == null) {
            throw new NullPointerException("messageRange is null.");
        }
        if (messagesRange.length == 0) {
            throw new IllegalArgumentException("messageRange is empty.");
        }
    }

    private void initialize(int[] messagesRange) {
        this.messages = new int[messagesRange.length];
        System.arraycopy(messagesRange, 0, this.messages, 0, messagesRange.length);
        Arrays.sort(this.messages);
    }
}

