/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.metadata;

import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgOperation;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgEnum;
import com.genesyslab.platform.configuration.protocol.runtime.schemas.Cfglibschema;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectProperty;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CfgDescriptionAttribute
extends CfgDescription
implements ICfgEnum<CfgObjectProperty> {
    private String mapping;
    private CfgDescriptionClass parent;
    private boolean m_isKey;
    private CfgOperation operation = CfgOperation.Unknown;
    private CfgObjectProperty cfgType;
    private Long constValue = 0L;

    CfgDescriptionAttribute(CfgDescriptionClass parent, String name, String mapping, String enumLiteral, String action, boolean isKey, int index, int protocolVersion) {
        super(name, index, protocolVersion);
        this.parent = parent;
        this.mapping = mapping;
        this.m_isKey = isKey;
        if (enumLiteral != null) {
            this.cfgType = (CfgObjectProperty)CfgObjectProperty.getValue(CfgObjectProperty.class, (String)enumLiteral);
        }
        if (parent != null && !parent.isCfgType(CfgTypeMask.Enum)) {
            this.operation = this.isCfgType(CfgTypeMask.List) || this.isCfgType(CfgTypeMask.KvList) ? CfgOperation.Add : CfgOperation.Change;
        }
        if (action != null) {
            this.setOperation(action);
        }
    }

    CfgDescriptionAttribute(CfgDescriptionClass parent, Cfglibschema.TypeInfo.Attribute attributeInfo, int index) {
        this(parent, attributeInfo.getName(), attributeInfo.getMapping(), attributeInfo.getLibid(), attributeInfo.getAction(), attributeInfo.getKey() != null ? "yes".equals(attributeInfo.getKey()) : false, index, attributeInfo.getMinVersion() != null ? attributeInfo.getMinVersion() : 0);
    }

    public Long getConst() {
        return this.constValue;
    }

    void setConst(Long long1) {
        this.constValue = long1;
    }

    public CfgDescriptionClass getParent() {
        return this.parent;
    }

    void setParent(CfgDescriptionClass parent) {
        this.parent = parent;
    }

    public boolean isKey() {
        return this.m_isKey;
    }

    void setKey(boolean isKey) {
        this.m_isKey = isKey;
    }

    public String getMappingName() {
        return this.mapping;
    }

    void setMappingName(String mappingName) {
        this.mapping = mappingName;
    }

    public String getSchemaName() {
        return this.getName();
    }

    public CfgOperation getOperation() {
        return this.operation;
    }

    @Override
    public CfgObjectProperty getCfgEnum() {
        return this.cfgType;
    }

    void setCfgEnum(CfgObjectProperty cfgEnum) {
        this.cfgType = cfgEnum;
    }

    public abstract Object getValue(Element var1);

    @Override
    protected void setTypeMask() {
        this.addTypeToMask(CfgTypeMask.Attribute);
    }

    @Override
    protected void setComparer() {
        this.setComparer(CfgMetadata.getBaseComparer());
    }

    private void setOperation(String operation) {
        if ("delete".equals(operation)) {
            this.operation = CfgOperation.Remove;
        } else if ("add".equals(operation)) {
            this.operation = CfgOperation.Add;
        } else if ("change".equals(operation)) {
            this.operation = CfgOperation.Change;
        } else {
            throw new IllegalArgumentException("Unknown operation " + operation);
        }
    }
}

