/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.metadata;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeDateTime;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeEnumItem;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeInteger;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeKvList;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeKvListDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClassDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClassList;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceClassListDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceKeyListDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceLink;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceLinkList;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReferenceLinkListDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeString;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionEnum;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructure;
import com.genesyslab.platform.configuration.protocol.metadata.CfgKeysComparer;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgOperation;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.metadata.ICfgClassOperationalInfo;
import com.genesyslab.platform.configuration.protocol.runtime.schemas.Cfglibschema;
import com.genesyslab.platform.configuration.protocol.types.CfgClassType;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectProperty;
import com.genesyslab.platform.configuration.protocol.utilities.CfgUtilities;
import com.genesyslab.platform.configuration.protocol.utilities.Linq;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditions;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditionsAdaptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CfgDescriptionClass
extends CfgDescription {
    private Collection<CfgDescriptionAttribute> attributes = new LinkedList<CfgDescriptionAttribute>();
    private Hashtable<String, CfgDescriptionAttribute> attrByName = new Hashtable();
    private Hashtable<String, CfgDescriptionAttribute> attrBySchemaName = new Hashtable();
    private ICfgClassOperationalInfo delta;
    private CfgKeysComparer keysEqualityComparer = new CfgKeysComparer(this);
    private CfgClassType type;

    CfgDescriptionClass(String name, int enumCode, int protocolVersion) {
        super(name, enumCode, protocolVersion);
        this.type = (CfgClassType)GEnum.getValue(CfgClassType.class, (int)enumCode);
    }

    CfgDescriptionClass(Cfglibschema.TypeInfo typeInfo, int enumCode) {
        this(typeInfo.getName(), enumCode, 380);
    }

    public CfgClassType getClassEnum() {
        return this.type;
    }

    void setClassEnum(CfgClassType value) {
        this.type = value;
    }

    public Collection<CfgDescriptionAttribute> getAttributes() {
        return this.attributes;
    }

    public Collection<CfgDescriptionAttribute> getKeys() {
        return Linq.selectWithOrder(this.getAttributes(), new LinqConditions<CfgDescriptionAttribute>(){

            @Override
            public boolean condition(CfgDescriptionAttribute item) {
                return item.isKey();
            }

            @Override
            public int compare(CfgDescriptionAttribute paramT1, CfgDescriptionAttribute paramT2) {
                return paramT1.getIndex() - paramT2.getIndex();
            }
        });
    }

    public CfgDescriptionAttribute getAttributeByName(String attributeName) {
        return this.attrByName.get(attributeName);
    }

    public CfgDescriptionAttribute getAttribute(String schemaName) {
        return this.attrBySchemaName.get(schemaName);
    }

    public List<Node> getKeys(Node clazz) {
        List<Node> keys = new LinkedList<Node>();
        if (clazz != null) {
            for (Element element : CfgUtilities.getChildElements(clazz)) {
                CfgDescriptionAttribute attributeDescription = this.getAttributeByName(element.getLocalName());
                String attributeValue = element.getAttribute("value");
                if (attributeValue == null || !attributeDescription.isKey() || attributeValue.equals("") || attributeValue.equals("0")) continue;
                keys.add(element);
            }
            Node[] arr = keys.toArray(new Node[keys.size()]);
            Arrays.sort(arr, new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    int index1 = CfgDescriptionClass.this.getAttributeByName(o1.getLocalName()).getIndex();
                    int index2 = CfgDescriptionClass.this.getAttributeByName(o2.getLocalName()).getIndex();
                    return index1 - index2;
                }
            });
            keys = Arrays.asList(arr);
        }
        return keys;
    }

    public ICfgClassOperationalInfo getDelta() {
        return this.delta;
    }

    void setDelta(ICfgClassOperationalInfo value) {
        this.delta = value;
    }

    public CfgKeysComparer getEqualityComparer() {
        return this.keysEqualityComparer;
    }

    public CfgDescriptionAttribute getDeltaListAttribute(final String mappingName, final CfgOperation operation) {
        CfgDescriptionAttributeReference listItemsAttributeDescription;
        List<CfgDescriptionAttribute> listItemsAttributesDescriptionsQuery = Linq.select(this.getAttributes(), new LinqConditionsAdaptor<CfgDescriptionAttribute>(){

            @Override
            public boolean condition(CfgDescriptionAttribute item) {
                return mappingName != null && mappingName.equals(item.getMappingName()) && operation != null && operation.equals((Object)item.getOperation());
            }
        });
        int count = listItemsAttributesDescriptionsQuery.size();
        if (count == 1) {
            listItemsAttributeDescription = (CfgDescriptionAttributeReference)listItemsAttributesDescriptionsQuery.iterator().next();
        } else {
            if (count > 1) {
                throw new ArithmeticException();
            }
            listItemsAttributeDescription = null;
        }
        return listItemsAttributeDescription;
    }

    @Override
    protected void setTypeMask() {
        this.addTypeToMask(CfgTypeMask.Class);
    }

    @Override
    protected void setComparer() {
        this.setComparer(new CfgKeysComparer(this));
    }

    void addAttribute(CfgDescriptionAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Argument attribute");
        }
        this.attributes.add(attribute);
        this.attrByName.put(attribute.getName(), attribute);
        this.attrBySchemaName.put(attribute.getSchemaName(), attribute);
    }

    void removeAttribute(CfgDescriptionAttribute attribute) {
        if (attribute == null) {
            throw new NullPointerException("Argument attribute");
        }
        this.attributes.remove(attribute);
        this.attrByName.remove(attribute.getName());
        this.attrBySchemaName.remove(attribute.getSchemaName());
    }

    void loadAttributes(Cfglibschema.TypeInfo typeInfo, CfgMetadata metadata) {
        int index = 0;
        for (Cfglibschema.TypeInfo.Attribute attributeInfo : typeInfo.getAttribute()) {
            int minVersion = attributeInfo.getMinVersion() == null ? 0 : attributeInfo.getMinVersion();
            if (minVersion > metadata.getProtocolVersion()) continue;
            CfgDescriptionAttribute attributeDescription = !"delta".equalsIgnoreCase(typeInfo.getClazz()) ? this.createAttributeDescription(attributeInfo, index++, metadata) : this.createDeltaAttributeDescription(attributeInfo, index++, metadata);
            this.addAttribute(attributeDescription);
            if (!"CfgGroup".equals(attributeInfo.getRef())) continue;
            this.addTypeToMask(CfgTypeMask.Group);
            attributeDescription.addTypeToMask(CfgTypeMask.Group);
        }
    }

    private CfgDescriptionAttribute createAttributeDescription(Cfglibschema.TypeInfo.Attribute attributeInfo, int index, CfgMetadata metadata) {
        CfgDescriptionAttribute attributeDescription = null;
        if ("time".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeDateTime(this, attributeInfo, index);
        } else if ("long".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeInteger(this, attributeInfo, index);
        } else if ("int".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = attributeInfo.getRef() != null ? this.createEnumItem(attributeInfo, index, metadata) : new CfgDescriptionAttributeInteger(this, attributeInfo, index);
        } else if ("ulong".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = attributeInfo.getLinkType() != null ? new CfgDescriptionAttributeReferenceLink(this, attributeInfo, index, metadata) : new CfgDescriptionAttributeInteger(this, attributeInfo, index);
        } else if ("string".equalsIgnoreCase(attributeInfo.getStyle().toString()) || "gstring".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeString(this, attributeInfo, index);
        } else if ("object".equalsIgnoreCase(attributeInfo.getStyle().toString()) || "pobject".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = this.createClassReferenceArttribute(attributeInfo, index, metadata);
        } else if ("objlist".equalsIgnoreCase(attributeInfo.getStyle().toString()) || "objhash".equalsIgnoreCase(attributeInfo.getStyle().toString()) || "pobjhash".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeReferenceClassList(this, attributeInfo, index, metadata);
        } else if ("dbidlist".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeReferenceLinkList(this, attributeInfo, index, metadata);
        } else if ("kvlist".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeKvList(this, attributeInfo, index);
        } else if ("intlist".equalsIgnoreCase(attributeInfo.getStyle().toString()) || "strlist".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeReferenceKeyListDelta(this, attributeInfo, index, metadata);
        } else {
            throw new UnsupportedOperationException("CfgType '" + (Object)((Object)attributeInfo.getStyle()) + "' is not supported");
        }
        if (this.isCfgType(CfgTypeMask.Alias) && ((CfgDescriptionStructure)this).getAlias() != null) {
            attributeDescription.setKey(((CfgDescriptionStructure)this).getAlias().getAttributeByName(attributeDescription.getName()).isKey());
        }
        return attributeDescription;
    }

    private CfgDescriptionAttribute createDeltaAttributeDescription(Cfglibschema.TypeInfo.Attribute attributeInfo, int index, CfgMetadata metadata) {
        CfgDescriptionAttributeReference attributeDescription = null;
        if ("object".equalsIgnoreCase(attributeInfo.getStyle().toString()) || "pobject".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = this.createClassReferenceArttribute(attributeInfo, index, metadata);
        } else if ("objlist".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeReferenceClassListDelta(this, attributeInfo, index, metadata);
        } else if ("dbidlist".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeReferenceLinkListDelta(this, attributeInfo, index, metadata);
        } else if ("kvlist".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeKvListDelta(this, attributeInfo, index);
        } else if ("intlist".equalsIgnoreCase(attributeInfo.getStyle().toString()) || "strlist".equalsIgnoreCase(attributeInfo.getStyle().toString())) {
            attributeDescription = new CfgDescriptionAttributeReferenceKeyListDelta(this, attributeInfo, index, metadata);
        } else {
            throw new UnsupportedOperationException("Type '" + (Object)((Object)attributeInfo.getStyle()) + "' is not supported in 'CfgDeltaDescription'");
        }
        return attributeDescription;
    }

    private CfgDescriptionAttributeReferenceClass createClassReferenceArttribute(Cfglibschema.TypeInfo.Attribute attributeInfo, int index, CfgMetadata metadata) {
        CfgDescriptionAttributeReferenceClass attributeDescription = null;
        Object reference = metadata.getCfgClass(attributeInfo.getRef());
        if (((CfgDescription)reference).isCfgType(CfgTypeMask.Delta)) {
            attributeDescription = new CfgDescriptionAttributeReferenceClassDelta(this, attributeInfo, index, metadata);
        } else if (((CfgDescription)reference).isCfgType(CfgTypeMask.Object) || ((CfgDescription)reference).isCfgType(CfgTypeMask.Structure)) {
            attributeDescription = new CfgDescriptionAttributeReferenceClass(this, attributeInfo, index, metadata);
        } else {
            throw new UnsupportedOperationException("Attribute '" + ((CfgDescription)reference).getName() + " mask=" + ((CfgDescription)reference).getTypeMaskString() + "' is not supported in 'CfgDeltaDescription");
        }
        return attributeDescription;
    }

    private CfgDescriptionAttribute createEnumItem(Cfglibschema.TypeInfo.Attribute attributeInfo, int index, CfgMetadata metadata) {
        Class<?> enumType;
        try {
            enumType = Class.forName(CfgDescriptionEnum.CFG_ENUM_NS + '.' + attributeInfo.getRef());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        CfgDescriptionAttributeEnumItem enumObject = new CfgDescriptionAttributeEnumItem();
        enumObject.setParent(this);
        enumObject.setName(attributeInfo.getName());
        enumObject.setMappingName(attributeInfo.getMapping());
        enumObject.setIndex(index);
        if (attributeInfo.getKey() != null) {
            enumObject.setKey("yes".equals(attributeInfo.getKey()));
        }
        enumObject.setEnumDescription(metadata.getEnum(attributeInfo.getRef()));
        if (attributeInfo.getDefault() != null) {
            enumObject.setDefaultEnumValue(GEnum.getValue(enumType, (String)attributeInfo.getDefault()));
        }
        if (attributeInfo.getMinVersion() != null && attributeInfo.getMinVersion() != 0) {
            enumObject.setProtocolVersion(attributeInfo.getMinVersion());
        }
        if (attributeInfo.getConst() != null && attributeInfo.getConst() != 0) {
            enumObject.setConst(attributeInfo.getConst().longValue());
        }
        enumObject.setCfgEnum((CfgObjectProperty)GEnum.getValue(CfgObjectProperty.class, (String)attributeInfo.getLibid()));
        return enumObject;
    }
}

