/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.metadata;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.util.ResourcesUtil;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import com.genesyslab.platform.configuration.protocol.confserver.ConfServerProtocolFactory;
import com.genesyslab.platform.configuration.protocol.metadata.CfgBaseComparer;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeEnumItem;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionEnum;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObjectBriefInfo;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObjectDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructure;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructureDelta;
import com.genesyslab.platform.configuration.protocol.metadata.CfgKvKeysComparer;
import com.genesyslab.platform.configuration.protocol.metadata.CfgNameComparer;
import com.genesyslab.platform.configuration.protocol.metadata.CfgNodeEqualityComparer;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.metadata.CfgValueComparer;
import com.genesyslab.platform.configuration.protocol.runtime.metadata.CfgDescriptionSchema;
import com.genesyslab.platform.configuration.protocol.runtime.schemas.Cfglibschema;
import com.genesyslab.platform.configuration.protocol.types.CfgEnumType;
import com.genesyslab.platform.configuration.protocol.types.CfgObjectType;
import com.genesyslab.platform.configuration.protocol.types.CfgStructureType;
import com.genesyslab.platform.configuration.protocol.utilities.CfgUtilities;
import com.genesyslab.platform.configuration.protocol.utilities.Linq;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditions;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditionsAdaptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CfgMetadata {
    public static final String ClientProtocolVersion = "CfgProtocol 5.1.3.80";
    public static final int MaxProtocolVersion = 380;
    public static final int MinProtocolVersion = 360;
    public static final int CfgRoleProtocolVersion = 373;
    public static final String RootLocalName = "ConfData";
    public static final String ValueAttributeName = "value";
    private static final int MaxNumberOfClasses = 150;
    private static final int MaxNumberOfObjects = 47;
    private static final int MaxNumberOfReservedDescriptions = 70;
    private static final String CfgPidSchema = "resources/cfgpid.xml";
    static final String XmlContentErrorMessage = "Invalid xml content";
    static final String CfgObjectTypeEnum = "CfgObjectType";
    static final String CfgStructureTypeEnum = "CfgStructureType";
    private Collection<CfgDescriptionClass> classDescriptions;
    private Hashtable<String, CfgDescriptionClass> classByName;
    private Hashtable<Integer, CfgDescriptionClass> classById;
    private Collection<CfgDescription> enumDescriptions;
    private Collection<CfgDescription> reservedDescriptions = new LinkedList<CfgDescription>();
    private int protocolVersion = 380;
    public static volatile boolean useConfDataNs = true;
    public static volatile boolean useLocalization = false;
    private static String ProtocolNs = ConfServerProtocolFactory.PROTOCOL_DESCRIPTION.getNS();
    private static String EmptyNs = "";
    private static CfgKvKeysComparer kvKeysComparer = new CfgKvKeysComparer();
    private static CfgValueComparer valueComparer = new CfgValueComparer();
    private static CfgNameComparer nameComparer = new CfgNameComparer();
    private static CfgNodeEqualityComparer nodeEqualityComparer = new CfgNodeEqualityComparer();
    private static CfgBaseComparer baseComparer = new CfgBaseComparer();
    private Element objectsSchema;
    private Element localesSchema;
    private Element pidsSchema;
    private Cfglibschema xsdSchema = null;
    private boolean doUpdateXsdSchema = true;

    public CfgMetadata() throws ProtocolException {
        this.classDescriptions = new LinkedList<CfgDescriptionClass>();
        this.classByName = new Hashtable(150);
        this.classById = new Hashtable(47);
        this.enumDescriptions = new LinkedList<CfgDescription>();
        try {
            InputStream schemaStream = ResourcesUtil.getResourceAsStream((String)"resources/cfglibschema.xml", this.getClass());
            this.objectsSchema = XmlFactories.newDocumentBuilder().parse(schemaStream).getDocumentElement();
        }
        catch (Exception e) {
            throw new ProtocolException("Exception loading configuration schema", (Throwable)e);
        }
        this.load();
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public Cfglibschema getSchema() throws ProtocolException {
        if (this.xsdSchema == null || this.doUpdateXsdSchema) {
            this.xsdSchema = this.createXsdSchema();
        }
        return this.xsdSchema;
    }

    public Element getObjectSchema() {
        return this.objectsSchema;
    }

    public void setObjectSchema(Element schema) {
        this.objectsSchema = schema;
        this.doUpdateXsdSchema = true;
    }

    public void parseObjectSchema(String schema) {
        try {
            this.objectsSchema = (Element)XmlFactories.newDocumentBuilder().parse(new ByteArrayInputStream(schema.getBytes())).getDocumentElement().getParentNode();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.doUpdateXsdSchema = true;
    }

    public Collection<CfgDescription> getEnums() {
        return this.enumDescriptions;
    }

    public Collection<CfgDescriptionClass> getClasses() {
        return Linq.select(this.classDescriptions, new LinqConditionsAdaptor<CfgDescriptionClass>(){

            @Override
            public boolean condition(CfgDescriptionClass item) {
                return item != null && !item.isCfgType(CfgTypeMask.Schema);
            }
        });
    }

    public <T extends CfgDescriptionClass> Collection<T> getClasses(final Class<T> clazz) {
        return Linq.select(this.getClasses(), new LinqConditionsAdaptor<T>(){

            @Override
            public boolean condition(T item) {
                if (clazz == null) {
                    return true;
                }
                return clazz.isAssignableFrom(item.getClass());
            }
        });
    }

    public <T extends CfgDescriptionClass> T getCfgClass(String value) {
        return (T)this.classByName.get(value);
    }

    public <T extends CfgDescriptionClass, E> T getCfgClass(Class<T> clazz, E cfgEnum) {
        String name = CfgUtilities.enumLiteralToName(cfgEnum.toString());
        if (CfgDescriptionObjectDelta.class.equals(clazz) || CfgDescriptionStructureDelta.class.equals(clazz)) {
            return (T)((CfgDescriptionClass)((Object)this.classByName.get(name).getDelta()));
        }
        return this.getCfgClass(name);
    }

    public <T extends CfgDescriptionObject> T getObject(final Class<T> clazz, final CfgObjectType objectType) {
        return (T)((CfgDescriptionObject)Linq.firstOrDefault(this.getClasses(clazz), new LinqConditionsAdaptor<T>(){

            @Override
            public boolean condition(T item) {
                return ((CfgDescription)item).isCfgType(CfgTypeMask.Object) && ((CfgDescriptionObject)item).getCfgEnum() == objectType && (CfgDescriptionObjectDelta.class.equals((Object)clazz) ? ((CfgDescription)item).isCfgType(CfgTypeMask.Delta) : !((CfgDescription)item).isCfgType(CfgTypeMask.Delta));
            }
        }));
    }

    public <T extends CfgDescriptionStructure> T getStructure(final Class<T> clazz, final CfgStructureType structType) {
        return (T)((CfgDescriptionStructure)Linq.firstOrDefault(this.getClasses(clazz), new LinqConditionsAdaptor<T>(){

            @Override
            public boolean condition(T item) {
                return ((CfgDescription)item).isCfgType(CfgTypeMask.Structure) && ((CfgDescriptionStructure)item).getCfgEnum() == structType && (CfgDescriptionStructureDelta.class.equals((Object)clazz) ? ((CfgDescription)item).isCfgType(CfgTypeMask.Delta) : !((CfgDescription)item).isCfgType(CfgTypeMask.Delta));
            }
        }));
    }

    public <E extends GEnum> CfgDescriptionEnum<E> getEnum(final String name) {
        return (CfgDescriptionEnum)Linq.firstOrDefault(this.getEnums(), new LinqConditionsAdaptor<CfgDescription>(){

            @Override
            public boolean condition(CfgDescription item) {
                return item.getName().equals(name);
            }
        });
    }

    public <E extends GEnum> CfgDescriptionEnum<E> getEnum(CfgEnumType enumType) {
        return this.getEnum(enumType.toString());
    }

    public CfgDescriptionObject getClassById(Integer id) {
        return (CfgDescriptionObject)this.classById.get(id);
    }

    public static CfgKvKeysComparer getKvKeysComparer() {
        return kvKeysComparer;
    }

    public static CfgValueComparer getValueComparer() {
        return valueComparer;
    }

    public static CfgNameComparer getNameComparer() {
        return nameComparer;
    }

    public static CfgNodeEqualityComparer getNodeEqualityComparer() {
        return nodeEqualityComparer;
    }

    public static CfgBaseComparer getBaseComparer() {
        return baseComparer;
    }

    public void update(int protocolVersion) {
        if (protocolVersion == this.protocolVersion) {
            return;
        }
        if (protocolVersion > 380 || protocolVersion < 360) {
            throw new UnsupportedOperationException("ProtocolVersion [" + protocolVersion + "] is not supported");
        }
        this.adjustMetadataVersion(protocolVersion);
        this.protocolVersion = protocolVersion;
        this.doUpdateXsdSchema = true;
    }

    public static String getNs() {
        return useConfDataNs ? ProtocolNs : EmptyNs;
    }

    public void setLocalesSchema(Element value) {
        this.localesSchema = value;
    }

    public void loadLocales() throws ProtocolException {
        this.loadPidSchema();
        this.loadEnumLocales();
        this.loadClassLocales();
    }

    private void addClass(CfgDescriptionClass cfgClass) {
        if (cfgClass == null) {
            throw new NullPointerException("xClass");
        }
        this.classDescriptions.add(cfgClass);
        this.classByName.put(cfgClass.getName(), cfgClass);
        if (cfgClass.isCfgType(CfgTypeMask.Object) && !cfgClass.isCfgType(CfgTypeMask.Delta) && !cfgClass.isCfgType(CfgTypeMask.BriefInfo)) {
            this.classById.put(cfgClass.getIndex(), cfgClass);
        }
    }

    private void removeClass(CfgDescriptionClass cfgClass) {
        if (cfgClass == null) {
            throw new NullPointerException("xClass");
        }
        this.classDescriptions.remove(cfgClass);
        this.classByName.remove(cfgClass.getName());
        if (cfgClass.isCfgType(CfgTypeMask.Object) && !cfgClass.isCfgType(CfgTypeMask.Delta) && !cfgClass.isCfgType(CfgTypeMask.BriefInfo)) {
            this.classById.remove(cfgClass.getIndex());
        }
    }

    private void addEnum(CfgDescription cfgEnum) {
        if (cfgEnum == null) {
            throw new NullPointerException("@enum");
        }
        this.enumDescriptions.add(cfgEnum);
    }

    private void removeEnum(CfgDescription cfgEnum) {
        if (cfgEnum == null) {
            throw new NullPointerException("@enum");
        }
        this.enumDescriptions.remove(cfgEnum);
    }

    private void adjustMetadataVersion(final int protocolVersion) {
        block5: {
            block4: {
                if (protocolVersion >= this.protocolVersion) break block4;
                for (CfgDescriptionClass classDescription : this.classDescriptions) {
                    List<CfgDescriptionAttribute> notSupportedAttributeDescriptionsQuery = Linq.select(classDescription.getAttributes(), new LinqConditionsAdaptor<CfgDescriptionAttribute>(){

                        @Override
                        public boolean condition(CfgDescriptionAttribute item) {
                            return item.getProtocolVersion() > protocolVersion;
                        }
                    });
                    for (CfgDescriptionAttribute desk : notSupportedAttributeDescriptionsQuery) {
                        if (!this.reservedDescriptions.contains(desk)) {
                            this.reservedDescriptions.add(desk);
                        }
                        classDescription.removeAttribute(desk);
                    }
                }
                break block5;
            }
            if (protocolVersion <= this.protocolVersion) break block5;
            List<CfgDescription> reservedAttributeDescriptionsQuery = Linq.selectWithOrder(this.reservedDescriptions, new LinqConditions<CfgDescription>(){

                @Override
                public boolean condition(CfgDescription item) {
                    return item.isCfgType(CfgTypeMask.Attribute) && item.getProtocolVersion() <= protocolVersion && item.getProtocolVersion() > CfgMetadata.this.protocolVersion;
                }

                @Override
                public int compare(CfgDescription paramT1, CfgDescription paramT2) {
                    return paramT1.getIndex() - paramT2.getIndex();
                }
            });
            for (CfgDescription attributeDescription : reservedAttributeDescriptionsQuery) {
                if (!(attributeDescription instanceof CfgDescriptionAttribute)) continue;
                ((CfgDescriptionAttribute)attributeDescription).getParent().addAttribute((CfgDescriptionAttribute)attributeDescription);
            }
        }
    }

    private void load() throws ProtocolException {
        this.loadEnums();
        this.loadClasses();
        this.loadAttributes();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadClasses() throws ProtocolException {
        Cfglibschema schema = this.getSchema();
        for (Cfglibschema.TypeInfo typeInfo : schema.getTypeInfo()) {
            void var4_4;
            Object var4_5 = null;
            int enumCode = -99;
            if (typeInfo.getClazz() == null) {
                CfgDescriptionStructure cfgDescriptionStructure = new CfgDescriptionStructure(typeInfo, this);
            } else if ("structure".equals(typeInfo.getClazz())) {
                enumCode = -1;
                if (typeInfo.getId() != null) {
                    enumCode = this.getEnum(CfgStructureTypeEnum).getItem(typeInfo.getId()).getDefaultEnumValue().ordinal();
                }
                CfgDescriptionStructure cfgDescriptionStructure = new CfgDescriptionStructure(typeInfo, enumCode);
            } else if ("object".equals(typeInfo.getClazz())) {
                CfgDescriptionObject cfgDescriptionObject = new CfgDescriptionObject(typeInfo, typeInfo.getId() != null ? this.getEnum(CfgObjectTypeEnum).getItem(typeInfo.getId()).getDefaultEnumValue().ordinal() : -1);
            } else if ("delta".equals(typeInfo.getClazz())) {
                Object parent = this.getCfgClass(typeInfo.getRef());
                if (((CfgDescription)parent).isCfgType(CfgTypeMask.Structure)) {
                    enumCode = typeInfo.getRef() != null ? this.getEnum(CfgStructureTypeEnum).getItem(CfgUtilities.nameToEnumLiteral(typeInfo.getRef())).getDefaultEnumValue().ordinal() : -1;
                    CfgDescriptionStructureDelta cfgDescriptionStructureDelta = new CfgDescriptionStructureDelta(typeInfo, (CfgDescriptionClass)parent, enumCode, 380);
                } else {
                    if (!((CfgDescription)parent).isCfgType(CfgTypeMask.Object)) throw new ProtocolException("OperationNotSupportedException");
                    enumCode = typeInfo.getRef() != null ? this.getEnum(CfgObjectTypeEnum).getItem(CfgUtilities.nameToEnumLiteral(typeInfo.getRef())).getDefaultEnumValue().ordinal() : -1;
                    CfgDescriptionObjectDelta cfgDescriptionObjectDelta = new CfgDescriptionObjectDelta(typeInfo, (CfgDescriptionClass)parent, enumCode, 380);
                }
            } else if ("schema".equals(typeInfo.getClazz())) {
                enumCode = typeInfo.getId() != null ? this.getEnum(CfgStructureTypeEnum).getItem(typeInfo.getId()).getIndex() : -1;
                CfgDescriptionSchema cfgDescriptionSchema = new CfgDescriptionSchema(typeInfo, enumCode);
            } else {
                if (!"brief".equals(typeInfo.getClazz())) throw new ProtocolException("Type load exception Type: '" + typeInfo.getClazz() + "' is unsupported");
                CfgDescriptionObjectBriefInfo cfgDescriptionObjectBriefInfo = new CfgDescriptionObjectBriefInfo(typeInfo, typeInfo.getId() != null ? this.getEnum(CfgObjectTypeEnum).getItem(typeInfo.getId()).getDefaultEnumValue().ordinal() : -1);
            }
            this.addClass((CfgDescriptionClass)var4_4);
        }
    }

    private void loadAttributes() throws ProtocolException {
        Cfglibschema schema = this.getSchema();
        for (Cfglibschema.TypeInfo typeInfo : schema.getTypeInfo()) {
            if (!"structure".equals(typeInfo.getClazz())) continue;
            ((CfgDescriptionStructure)this.getCfgClass(typeInfo.getName())).loadAttributes(typeInfo, this);
        }
        for (Cfglibschema.TypeInfo typeInfo : schema.getTypeInfo()) {
            if (!"brief".equals(typeInfo.getClazz())) continue;
            ((CfgDescriptionObjectBriefInfo)this.getCfgClass(typeInfo.getName())).loadAttributes(typeInfo, this);
        }
        for (Cfglibschema.TypeInfo typeInfo : schema.getTypeInfo()) {
            if ("brief".equals(typeInfo.getClazz()) || "structure".equals(typeInfo.getClazz())) continue;
            ((CfgDescriptionClass)this.getCfgClass(typeInfo.getName())).loadAttributes(typeInfo, this);
        }
    }

    private void loadEnums() {
        for (Object obj : GEnum.values(CfgEnumType.class)) {
            if (!(obj instanceof CfgEnumType)) continue;
            CfgEnumType type2 = (CfgEnumType)((Object)obj);
            CfgDescriptionEnum cde = new CfgDescriptionEnum();
            cde.setName(type2.name());
            cde.setIndex(type2.ordinal());
            cde.setCfgEnum(type2);
            cde.loadItems();
            this.addEnum(cde);
        }
    }

    private void loadPidSchema() throws ProtocolException {
        if (this.pidsSchema != null) {
            return;
        }
        try {
            InputStream schemaStream = ResourcesUtil.getResourceAsStream((String)CfgPidSchema, this.getClass());
            Document doc = XmlFactories.newDocumentBuilder().parse(schemaStream);
            this.pidsSchema = doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new ProtocolException("Exception loading PidSchema", (Throwable)e);
        }
    }

    private void loadEnumLocales() throws ProtocolException {
        if (this.pidsSchema == null || this.localesSchema == null) {
            throw new ProtocolException("CfgMetadata: localesSchema schemas are not set.");
        }
        List<Node> enumLocalesQuery = Linq.select(this.localesSchema.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

            @Override
            public boolean condition(Node item) {
                return item.getNodeName().equals("cfglib_enumerator");
            }
        });
        for (CfgDescription enumDesc : this.getEnums()) {
            final String index = enumDesc.getName().equals(CfgStructureTypeEnum) ? "28" : Integer.toString(enumDesc.getIndex());
            Node enumLocales = Linq.firstOrDefault(enumLocalesQuery, new LinqConditionsAdaptor<Node>(){

                @Override
                public boolean condition(Node item) {
                    Node ret = Linq.firstOrDefault(item.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                        @Override
                        public boolean condition(Node elem) {
                            return elem.getNodeName().equals("dwID") && ((Element)elem).getAttribute(CfgMetadata.ValueAttributeName).equals(index);
                        }
                    });
                    return ret != null;
                }
            });
            if (enumLocales == null) continue;
            ((CfgDescriptionEnum)enumDesc).loadLocales((Element)enumLocales);
        }
    }

    private void loadClassLocales() {
        List<Node> enumLocalesQuery = Linq.select(this.localesSchema.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

            @Override
            public boolean condition(Node item) {
                return item.getNodeName().equals("cfglib_enumerator");
            }
        });
        Element propertyLocales = (Element)Linq.first(enumLocalesQuery, new LinqConditionsAdaptor<Node>(){

            @Override
            public boolean condition(Node item) {
                Node res = Linq.firstOrDefault(item.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                    @Override
                    public boolean condition(Node item2) {
                        return item2.getNodeName().equals("dwID") && ((Element)item2).getAttribute(CfgMetadata.ValueAttributeName).equals("34");
                    }
                });
                return res != null;
            }
        });
        List<Node> classesPids = Linq.select(this.pidsSchema.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

            @Override
            public boolean condition(Node item) {
                return item.getNodeName().equals("type_info");
            }
        });
        for (CfgDescriptionClass classDescI : this.getClasses()) {
            if (classDescI.isCfgType(CfgTypeMask.Schema) || classDescI.isCfgType(CfgTypeMask.Delta)) continue;
            final CfgDescriptionClass classDesc = classDescI;
            classDesc.setLocalizedName(this.getClassLocale(classDesc));
            Node classPids = Linq.firstOrDefault(classesPids, new LinqConditionsAdaptor<Node>(){

                @Override
                public boolean condition(Node elem) {
                    String elemName = ((Element)elem).getAttribute("name");
                    return elemName.equals(classDesc.getName()) || classDesc.isCfgType(CfgTypeMask.Structure) && elemName.equals(((CfgDescriptionStructure)classDesc).getAliasName());
                }
            });
            if (classPids == null) continue;
            int classId = classDesc.isCfgType(CfgTypeMask.Structure) ? ((CfgDescriptionStructure)classDesc).getCfgEnum().asInteger() : ((CfgDescriptionObject)classDesc).getCfgEnum().asInteger();
            Iterator<CfgDescriptionAttribute> i$ = classDesc.getAttributes().iterator();
            while (i$.hasNext()) {
                CfgDescriptionAttribute propDescI;
                final CfgDescriptionAttribute propDesc = propDescI = i$.next();
                Element pidElement = (Element)Linq.firstOrDefault(classPids.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                    @Override
                    public boolean condition(Node elem) {
                        if (elem instanceof Element) {
                            return ((Element)elem).getAttribute("name").equals(propDesc.getSchemaName());
                        }
                        return false;
                    }
                });
                if (pidElement == null) {
                    if (propDesc.isCfgType(CfgTypeMask.List) || !propDesc.isCfgType(CfgTypeMask.Class)) continue;
                    CfgDescriptionClass refClassDesc = ((CfgDescriptionAttributeReference)propDesc).getCfgClass();
                    Iterator<CfgDescriptionAttribute> i$2 = refClassDesc.getAttributes().iterator();
                    while (i$2.hasNext()) {
                        CfgDescriptionAttribute propDesc2I;
                        final CfgDescriptionAttribute propDesc2 = propDesc2I = i$2.next();
                        pidElement = (Element)Linq.firstOrDefault(classPids.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                            @Override
                            public boolean condition(Node elem) {
                                if (elem instanceof Element) {
                                    return ((Element)elem).getAttribute("name").equals(propDesc.getSchemaName() + "_" + propDesc2.getSchemaName());
                                }
                                return false;
                            }
                        });
                        if (pidElement == null) continue;
                        propDesc2.setLocalizedName(CfgMetadata.getLocale(pidElement, propertyLocales, classId));
                    }
                    continue;
                }
                propDesc.setLocalizedName(CfgMetadata.getLocale(pidElement, propertyLocales, classId));
            }
        }
    }

    private String getClassLocale(CfgDescriptionClass classDescription) {
        if (classDescription.isCfgType(CfgTypeMask.Structure)) {
            CfgDescriptionEnum<CfgStructureType> structureTypes = this.getEnum(CfgEnumType.CfgStructureType);
            CfgDescriptionAttributeEnumItem<CfgStructureType> structureType = structureTypes.getItem(((CfgDescriptionStructure)classDescription).getCfgEnum());
            if (structureType == null) {
                return null;
            }
            return structureType.getLocalizedName();
        }
        if (classDescription.isCfgType(CfgTypeMask.BriefInfo)) {
            return null;
        }
        CfgDescriptionEnum<CfgObjectType> objectTypes = this.getEnum(CfgEnumType.CfgObjectType);
        CfgDescriptionAttributeEnumItem<CfgObjectType> objectType = objectTypes.getItem(((CfgDescriptionObject)classDescription).getCfgEnum());
        return objectType.getLocalizedName();
    }

    private static String getLocale(Element pidElement, Element propLocalesElement, int classId) {
        int pid = Integer.parseInt(pidElement.getAttribute("pid"));
        final int propLocaleId = pid | classId + 20000 << 16;
        NodeList enumPairsQuery = CfgUtilities.findChildElement(propLocalesElement, "pEnumPairs").getChildNodes();
        Node localeElement = Linq.firstOrDefault(enumPairsQuery, (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

            @Override
            public boolean condition(Node item) {
                Node ret = Linq.firstOrDefault(item.getChildNodes(), (LinqConditions<Node>)new LinqConditionsAdaptor<Node>(){

                    @Override
                    public boolean condition(Node elem) {
                        return elem.getNodeName().equals("dwID") && Integer.parseInt(((Element)elem).getAttribute(CfgMetadata.ValueAttributeName)) == propLocaleId;
                    }
                });
                return ret != null;
            }
        });
        if (localeElement != null && (localeElement = CfgUtilities.findChildElement(localeElement, "name")) != null) {
            return ((Element)localeElement).getAttribute(ValueAttributeName);
        }
        return null;
    }

    private Cfglibschema createXsdSchema() throws ProtocolException {
        Unmarshaller u;
        JAXBContext jc;
        try {
            jc = JAXBContext.newInstance((Class[])new Class[]{Cfglibschema.class});
        }
        catch (JAXBException e) {
            throw new ProtocolException("Exception initializing JAXBContext", (Throwable)e);
        }
        try {
            u = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new ProtocolException("Exception initializing JAXB Unmarshaller", (Throwable)e);
        }
        try {
            JAXBElement root = u.unmarshal((Source)new DOMSource(this.objectsSchema), Cfglibschema.class);
            this.doUpdateXsdSchema = false;
            return (Cfglibschema)root.getValue();
        }
        catch (JAXBException e) {
            throw new ProtocolException("Exception unmarshalling configuration schema", (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("CfgMetadata(protocol v");
        ret.append(this.protocolVersion);
        if (useLocalization) {
            ret.append(", localized");
        }
        ret.append(")");
        return ret.toString();
    }
}

