/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;

public class CharDelimitersV7 {
    public static final char Start = '\u0017';
    public static final char End = '\u0018';
    public static final char Integer = '\u0019';
    public static final char String = '\u001b';
    public static final char List = '\u001c';
    public static final char KVList = '\u001d';
    public static final char Binary = '\u001e';
    public static final char Struct = '\u001f';
    public static final char[] cfgLibEx = new char[]{'\u0017', '\u0018', '\u0019', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f'};

    private CharDelimitersV7() {
    }

    public static int indexOfAnyDelimiter(String str, int startIndex) {
        int len = str.length();
        if (len == 0 || startIndex < 0 || startIndex > len) {
            return -1;
        }
        for (int i = startIndex; i < len; ++i) {
            char chr = str.charAt(i);
            if (chr > '\u001f' || chr < '\u0017' || chr == '\u001a') continue;
            return i;
        }
        return -1;
    }

    public static TokenType getTokenType(char chr) {
        switch (chr) {
            case '\u0017': {
                return null;
            }
            case '\u0018': {
                return TokenType.END;
            }
            case '\u0019': {
                return TokenType.INTEGER;
            }
            case '\u001b': {
                return TokenType.STRING;
            }
            case '\u001c': {
                return TokenType.LIST;
            }
            case '\u001d': {
                return TokenType.KVLIST;
            }
            case '\u001e': {
                return TokenType.BINARY;
            }
            case '\u001f': {
                return TokenType.STRUCT;
            }
        }
        return TokenType.NONE;
    }
}

