/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionObject;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectDelta;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectsCollection;
import com.genesyslab.platform.configuration.protocol.runtime.codec.ConfObjectPackV7;

public class ConfObjectDeltaPackV7
extends ConfObjectPackV7 {
    protected CfgDescriptionObject getObjectDescription(CfgDescriptionObject objType) throws CodecException {
        CfgDescriptionObject deltaObjType = (CfgDescriptionObject)((Object)objType.getDelta());
        if (deltaObjType == null) {
            throw new CodecException("Delta Object type for '" + objType.getName() + "' does not exist in current schema");
        }
        return deltaObjType;
    }

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        if (this.serializer == null || customTypeObject == null) {
            return transportState;
        }
        String cfgStr = null;
        if (!(customTypeObject instanceof ConfObjectDelta)) {
            throw new CodecException("Invalid configuration object(s) type (" + customTypeObject.getClass().getName() + ")");
        }
        cfgStr = this.serializer.serialize((ConfObjectDelta)customTypeObject);
        if (cfgStr != null) {
            this.ensureOutgoingObjectTypeAttr(customTypeObject, id, transport, transportState);
            return transport.onAttribute(transportState, Integer.toString(9), cfgStr);
        }
        return transportState;
    }

    public void onMessageEnd() throws CodecException {
        if (this.serializer == null || this.confObjectsData == null) {
            return;
        }
        CfgDescriptionObject objectType = this.getObjectDescription();
        ConfObjectsCollection objects = this.serializer.deserialize(objectType, this.confObjectsData);
        this.confObjectsData = null;
        if (objects != null) {
            if (objects.size() == 1) {
                ((DataSupport)this.message).attributes().put("ObjectDelta", objects.get(0));
            } else {
                throw new CodecException("Update notification should contain only one delta object");
            }
        }
    }
}

