/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.threading;

import com.genesyslab.platform.commons.threading.AsyncInvoker;
import com.genesyslab.platform.commons.threading.SingleThreadInvoker;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InvokerFactory {
    private static final Object lock = new Object();
    private static final Map<String, RegistryEntry> registry = new HashMap<String, RegistryEntry>();

    private InvokerFactory() {
    }

    public static AsyncInvoker namedInvoker(String name) {
        return InvokerFactory.namedInvoker(name, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsyncInvoker namedInvoker(String name, int queueSize) {
        Object object = lock;
        synchronized (object) {
            SingleThreadInvoker invoker = null;
            RegistryEntry entry = registry.get(name);
            if (entry != null) {
                invoker = entry.getInvoker();
            }
            if (invoker == null) {
                invoker = queueSize <= 0 ? new SingleThreadInvoker(name) : new SingleThreadInvoker(name, queueSize);
                if (entry != null) {
                    entry.setInvoker(invoker);
                } else {
                    entry = new RegistryEntry(invoker);
                    registry.put(name, entry);
                }
            }
            entry.incUsage();
            return invoker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInvoker(String name) {
        Object object = lock;
        synchronized (object) {
            RegistryEntry entry = registry.get(name);
            if (entry != null) {
                entry.decUsage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doReleaseUnusedInvokers() {
        Object object = lock;
        synchronized (object) {
            Iterator<Map.Entry<String, RegistryEntry>> iterator = registry.entrySet().iterator();
            while (iterator.hasNext()) {
                RegistryEntry value;
                Map.Entry<String, RegistryEntry> entry = iterator.next();
                if (entry == null || (value = entry.getValue()) == null || value.usageCount > 0 || System.currentTimeMillis() - value.getLastRequested() <= 500L) continue;
                iterator.remove();
                SingleThreadInvoker inv = value.getInvoker();
                if (inv == null) continue;
                value.setInvoker(null);
                value = null;
                inv.release();
            }
        }
    }

    private static class RegistryEntry {
        private int usageCount = 0;
        private WeakReference<SingleThreadInvoker> invokerRef = null;
        private SingleThreadInvoker hardLink = null;
        private long lastRequested;

        public RegistryEntry(SingleThreadInvoker invoker) {
            this.setInvoker(invoker);
        }

        public int incUsage() {
            this.hardLink = null;
            this.lastRequested = System.currentTimeMillis();
            return ++this.usageCount;
        }

        public int decUsage() {
            if (this.usageCount <= 1) {
                this.hardLink = (SingleThreadInvoker)this.invokerRef.get();
            }
            this.lastRequested = System.currentTimeMillis();
            return --this.usageCount;
        }

        public void setInvoker(SingleThreadInvoker invoker) {
            this.invokerRef = invoker != null ? new WeakReference<SingleThreadInvoker>(invoker) : null;
            this.hardLink = null;
        }

        public SingleThreadInvoker getInvoker() {
            if (this.hardLink != null) {
                return this.hardLink;
            }
            if (this.invokerRef != null) {
                return (SingleThreadInvoker)this.invokerRef.get();
            }
            return null;
        }

        public long getLastRequested() {
            return this.lastRequested;
        }
    }
}

