/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection;

import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributeSubscriptionList {
    public static final String SUBSCRIPTION_LIST_KEY = "attribute_subscription_list";
    private Map<Integer, Set<String>> subscriptions = new HashMap<Integer, Set<String>>();

    public void applyToContext(ConnectionContext ctx) {
        ctx.setAttribute(SUBSCRIPTION_LIST_KEY, this);
    }

    public boolean contains(int messageId, String attrId) {
        return this.subscriptions.containsKey(messageId) && this.subscriptions.get(messageId).contains(attrId);
    }

    public void addAttribute(int messageId, String attributeId) {
        if (this.subscriptions.containsKey(messageId)) {
            Set<String> messageSubscriptions = this.subscriptions.get(messageId);
            if (!messageSubscriptions.contains(attributeId)) {
                messageSubscriptions.add(attributeId);
            }
        } else {
            HashSet<String> messageSubscriptions = new HashSet<String>();
            this.subscriptions.put(messageId, messageSubscriptions);
            messageSubscriptions.add(attributeId);
        }
    }

    public boolean removeAttribute(int messageId, String attrId) {
        if (this.subscriptions.containsKey(messageId)) {
            Set<String> messageSubscriptions = this.subscriptions.get(messageId);
            boolean removed = messageSubscriptions.remove(attrId);
            if (removed && messageSubscriptions.isEmpty()) {
                this.subscriptions.remove(messageId);
            }
            return removed;
        }
        return false;
    }

    public boolean removeWholeMessage(int messageId) {
        boolean contains = this.subscriptions.containsKey(messageId);
        if (contains) {
            this.subscriptions.remove(messageId);
        }
        return contains;
    }

    public static boolean attributeSubscribed(ConnectionContext context, int msgId, String attrId) {
        Object subscriptions = context.getAttribute(SUBSCRIPTION_LIST_KEY);
        return subscriptions instanceof AttributeSubscriptionList && ((AttributeSubscriptionList)subscriptions).contains(msgId, attrId);
    }
}

