/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionAcceptor;
import com.genesyslab.platform.commons.connection.ConnectionListener;
import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.impl.ConnectionFactory;
import com.genesyslab.platform.commons.connection.impl.netty.NettyConnectionFactory;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.net.InetAddress;
import java.net.SocketAddress;

public final class ConnectionManager {
    private static final ILogger log = Log.getLogger(ConnectionManager.class);
    public static final String CONN_FACTORY_KEY = "com.genesyslab.platform.commons.connection.factory.class";

    private ConnectionManager() {
    }

    public static Connection createConnection(String host, int port, ConnectionContext ctx) {
        ConnectionManager.ctxNotNull(ctx);
        ConnectionFactory factory = ConnectionManager.createConnectionFactory(ctx);
        Connection connection = factory.createConnectionImpl(host, port).getConnection();
        connection.setContext(ctx);
        return connection;
    }

    public static Connection createConnection(InetAddress address, int port, ConnectionContext ctx) {
        ConnectionManager.ctxNotNull(ctx);
        ConnectionFactory factory = ConnectionManager.createConnectionFactory(ctx);
        Connection connection = factory.createConnectionImpl(address, port).getConnection();
        connection.setContext(ctx);
        return connection;
    }

    public static ConnectionAcceptor createAcceptor(String host, int port, ConnectionListener listener, ConnectionContext ctx) {
        ConnectionManager.ctxNotNull(ctx);
        ConnectionFactory factory = ConnectionManager.createConnectionFactory(ctx);
        ConnectionAcceptor acceptor = factory.createAcceptor(host, port, listener);
        acceptor.setContext(ctx);
        return acceptor;
    }

    public static ConnectionAcceptor createAcceptor(SocketAddress address, ConnectionListener listener, ConnectionContext ctx) {
        ConnectionManager.ctxNotNull(ctx);
        ConnectionFactory factory = ConnectionManager.createConnectionFactory(ctx);
        ConnectionAcceptor acceptor = factory.createAcceptor(address, listener);
        acceptor.setContext(ctx);
        return acceptor;
    }

    private static ConnectionFactory createConnectionFactory(ConnectionContext ctx) {
        try {
            String connClassName = System.getProperty(CONN_FACTORY_KEY);
            if (connClassName != null) {
                Class<?> connClass = Class.forName(connClassName);
                return (ConnectionFactory)connClass.newInstance();
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception creating connection implementation. Default implementation will be used", (Throwable)e);
        }
        return ConnectionManager.createDefaultFactory(ctx);
    }

    private static void ctxNotNull(ConnectionContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("context is not allowed to be null");
        }
    }

    private static ConnectionFactory createDefaultFactory(ConnectionContext ctx) {
        return new NettyConnectionFactory();
    }
}

