/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection;

import com.genesyslab.platform.commons.collections.DataFormatException;
import com.genesyslab.platform.commons.collections.KVList;
import com.genesyslab.platform.commons.collections.KeyValueCollection;
import com.genesyslab.platform.commons.collections.TKVSerializer;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;

public final class ConnectionMessage
implements Cloneable {
    private static final ILogger log = Log.getLogger(ConnectionMessage.class);
    private int messageId;
    private HashMap storage;

    public ConnectionMessage(int id) {
        this.storage = new HashMap();
        this.messageId = id;
    }

    public ConnectionMessage(int id, int attrCount) {
        this.storage = new HashMap(attrCount << 1);
        this.messageId = id;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void add(int id, int val) {
        this.storage.put(new Integer(id), new Integer(val));
    }

    public void add(int id, Integer val) {
        this.addObject(id, val);
    }

    public void add(int id, long val) {
        this.storage.put(new Integer(id), new Long(val));
    }

    public void add(int id, Long val) {
        this.addObject(id, val);
    }

    public void add(int id, String val) {
        this.addObject(id, val);
    }

    public void add(int id, byte[] val) {
        this.addObject(id, val);
    }

    public void add(int id, KeyValueCollection val) {
        this.addObject(id, val);
    }

    public void add(int id, KeyValueCollection val, String encoding) throws UnsupportedEncodingException {
        byte[] bytes = TKVSerializer.getBytes((KVList)val, (String)encoding);
        this.addObject(id, bytes);
    }

    public Object deleteAttrib(int id) {
        return this.storage.remove(new Integer(id));
    }

    public Integer getInt(int id) {
        return (Integer)this.getObject(id, Integer.class);
    }

    public Long getLong(int id) {
        return (Long)this.getObject(id, Long.class);
    }

    public String getString(int id) {
        return (String)this.getObject(id, String.class);
    }

    public byte[] getBinary(int id) {
        return (byte[])this.getObject(id, byte[].class);
    }

    public KeyValueCollection getKeyValueCollection(int id) {
        try {
            return this.getKeyValueCollection(id, null);
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"Default encoding is unsupported?", (Throwable)e);
            return null;
        }
    }

    public KeyValueCollection getKeyValueCollection(int id, String encoding) throws UnsupportedEncodingException {
        Object obj = this.getObject(id);
        if (obj instanceof KeyValueCollection) {
            return (KeyValueCollection)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return TKVSerializer.deserialize((byte[])((byte[])obj), (String)encoding);
            }
            catch (DataFormatException e) {
                log.warn((Object)"Wrong or not a TKV in message", (Throwable)e);
            }
        } else {
            log.warn((Object)"Not a TKV in message");
        }
        return null;
    }

    public Object getObject(int id) {
        return this.storage.get(new Integer(id));
    }

    public Iterator getAttributeIds() {
        return this.storage.keySet().iterator();
    }

    public Iterator getEntries() {
        return this.storage.entrySet().iterator();
    }

    public int getAttributeCount() {
        return this.storage.size();
    }

    public Object clone() throws CloneNotSupportedException {
        ConnectionMessage msg = (ConnectionMessage)super.clone();
        msg.storage = (HashMap)this.storage.clone();
        return msg;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('(').append(this.messageId).append(") :");
        buf.append(this.storage.toString());
        return buf.toString();
    }

    private Object getObject(int id, Class objectType) {
        Object obj = this.storage.get(new Integer(id));
        if (obj == null) {
            if (log.isDebug()) {
                log.debug((Object)("No attribute '" + id + "' in message #" + this.messageId));
            }
            return null;
        }
        if (obj.getClass().equals(objectType)) {
            return obj;
        }
        if (log.isDebug()) {
            log.debug((Object)("Unexpected type. Attribute '" + id + "'in message #" + this.messageId));
        }
        return null;
    }

    private void addObject(int id, Object val) {
        if (val == null) {
            throw new NullPointerException("null values are not allowed in Message");
        }
        this.storage.put(new Integer(id), val);
    }
}

