/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.connection.ConnectionAcceptor;
import com.genesyslab.platform.commons.connection.ConnectionListener;
import com.genesyslab.platform.commons.connection.impl.AbstractAcceptorImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionFactory;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import java.net.InetAddress;
import java.net.SocketAddress;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    protected abstract ConnectionImpl createConnectionImpl();

    protected abstract AbstractAcceptorImpl createAcceptorImpl();

    public ConnectionImpl createConnectionImpl(String host, int port) {
        ConnectionImpl conn = this.createConnectionImpl();
        conn.setUri(host, port);
        return conn;
    }

    public ConnectionImpl createConnectionImpl(InetAddress address, int port) {
        ConnectionImpl conn = this.createConnectionImpl();
        conn.setUri(address, port);
        return conn;
    }

    public ConnectionAcceptor createAcceptor(String host, int port, ConnectionListener listener) {
        AbstractAcceptorImpl acceptor = this.createAcceptorImpl();
        acceptor.setUri(host, port);
        acceptor.setConnectionListener(listener);
        return acceptor;
    }

    public ConnectionAcceptor createAcceptor(SocketAddress address, ConnectionListener listener) {
        AbstractAcceptorImpl acceptor = this.createAcceptorImpl();
        acceptor.setUri(address);
        acceptor.setConnectionListener(listener);
        return acceptor;
    }
}

