/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.connection.impl.CommonMessageProducerImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.Constants;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.MessageProducer;
import com.genesyslab.platform.commons.connection.impl.MessageProducerFactory;
import com.genesyslab.platform.commons.connection.impl.ShiftByteArrayOutputStream;
import com.genesyslab.platform.commons.connection.interceptor.InterceptorImpl;
import com.genesyslab.platform.commons.connection.interceptor.NoInterceptorImpl;

public class StreamParser {
    private static final InterceptorImpl defaultInterceptor = new NoInterceptorImpl();
    private ConnectionImpl connImpl;
    private MessageProducerFactory producerFactory;
    private ShiftByteArrayOutputStream bytes;
    private int extLength = 0;
    private ShiftByteArrayOutputStream extBytes = null;

    public StreamParser(ConnectionImpl connImpl, MessageProducerFactory producerFactory) {
        this.connImpl = connImpl;
        this.producerFactory = producerFactory;
        this.bytes = new ShiftByteArrayOutputStream();
    }

    public void processBytes(byte[] buffer, int off, int len) throws InvalidPacketException {
        int size;
        this.bytes.write(buffer, off, len);
        while ((size = this.bytes.size()) > 0) {
            int packetLen = this.getPacketLen();
            if (packetLen < 0) {
                throw new InvalidPacketException("invalid packet");
            }
            if (packetLen == 0 || packetLen > size) {
                return;
            }
            this.processPacket(packetLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(int packetLen) throws InvalidPacketException {
        if (this.getInterceptor().processPacket(this.bytes, packetLen)) {
            return;
        }
        try {
            if (this.extLength > 0) {
                this.processExtendedPacket(packetLen);
            } else if (!this.checkProcessExtHeader(packetLen)) {
                byte[] b = this.bytes.getBuffer();
                MessageProducer producer = this.producerFactory.create(b, 4, packetLen - 4, this.connImpl.getConnection().getMessagePackager());
                producer.parse();
            }
        }
        finally {
            this.bytes.shiftBack(packetLen);
        }
    }

    private boolean checkProcessExtHeader(int packetLen) throws InvalidPacketException {
        byte[] buf;
        String sData;
        boolean isExtPacket = false;
        int dataLen = packetLen - 4;
        if (dataLen == Constants.EXTENDED_PACKET_TAG_LENGTH + 4 && (isExtPacket = (sData = new String(buf = this.bytes.getBuffer(), 4, dataLen - 4)).equals("$PACKET EXTENSION V1.00$"))) {
            if (this.extLength != 0) {
                throw new InvalidPacketException("ExtHeader spotted while processing extended packets");
            }
            this.extLength = CommonMessageProducerImpl.getInt(buf, packetLen - 4);
            this.extBytes = new ShiftByteArrayOutputStream(this.extLength);
        }
        return isExtPacket;
    }

    private int getPacketLen() {
        byte[] currentBuf = this.bytes.getBuffer();
        int len = this.bytes.size();
        return this.getInterceptor().getPacketLength(currentBuf, 0, len);
    }

    private void processExtendedPacket(int packetLen) throws InvalidPacketException {
        int dataLen = packetLen - 4;
        byte[] bb = this.bytes.getBuffer();
        this.extBytes.write(bb, 4, dataLen);
        this.extLength -= dataLen;
        if (this.extLength < 0) {
            throw new InvalidPacketException("extLen in header don't match sequence length");
        }
        if (this.extLength == 0) {
            byte[] buffer = this.extBytes.getBuffer();
            MessageProducer producer = this.producerFactory.create(buffer, 0, this.extBytes.size(), this.connImpl.getConnection().getMessagePackager());
            producer.parse();
        }
    }

    private InterceptorImpl getInterceptor() {
        InterceptorImpl interceptor = this.connImpl.getProtocol();
        if (interceptor == null) {
            return defaultInterceptor;
        }
        return interceptor;
    }
}

