/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.mina;

import com.genesyslab.platform.commons.connection.ConnectionAcceptor;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.AbstractAcceptorImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionAcceptorImpl;
import com.genesyslab.platform.commons.connection.impl.mina.MinaConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.mina.MinaUtil;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.IOException;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.transport.socket.nio.SocketAcceptor;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;

public class MinaAcceptor
extends AbstractAcceptorImpl
implements ConnectionAcceptor,
ConnectionAcceptorImpl {
    private static final ILogger log = Log.getLogger(MinaAcceptor.class);
    private IoAcceptor acceptor = new SocketAcceptor();

    protected MinaAcceptor() {
    }

    public void startAccepting() throws IOException {
        Boolean keepAlive;
        log.debug((Object)"Binding Mina...");
        SocketAcceptorConfig cfg = new SocketAcceptorConfig();
        cfg.setReuseAddress(true);
        ConnectionConfiguration config = this.context().configuration();
        if (null != config && null != (keepAlive = Boolean.valueOf(config.getBoolean("keep-alive")))) {
            cfg.getSessionConfig().setKeepAlive(keepAlive.booleanValue());
        }
        MinaUtil.configureSSL((IoServiceConfig)cfg, this.context(), true);
        this.acceptor.bind(this.address, (IoHandler)new AcceptorHandler(), (IoServiceConfig)cfg);
        log.debug((Object)"Socket is bound");
    }

    public void close() {
        this.acceptor.unbindAll();
    }

    public ConnectionAcceptor getAcceptor() {
        return this;
    }

    private class AcceptorHandler
    extends MinaConnectionImpl.Handler {
        private AcceptorHandler() {
        }

        public void sessionCreated(IoSession session) throws Exception {
            super.sessionCreated(session);
            log.debug((Object)("created " + session));
            MinaConnectionImpl impl = new MinaConnectionImpl();
            impl.attach(session);
            MinaAcceptor.this.newConnectionNotification(impl);
        }
    }
}

