/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.mina;

import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.connection.impl.mina.MinaConnectionImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;

public class MinaWritePipeImpl
implements WritePipe {
    private ILogger log = Log.getLogger(MinaWritePipeImpl.class);
    private final MinaConnectionImpl connection;
    private final List<ByteBuffer> pendingWrites = Collections.synchronizedList(new ArrayList());

    public MinaWritePipeImpl(MinaConnectionImpl minaConnection) {
        this.connection = minaConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(WritePoint writePoint) {
        if (writePoint instanceof WritePointImpl) {
            IoSession session = this.connection.getSession();
            if (session != null) {
                if (!this.pendingWrites.isEmpty()) {
                    this.writePendingData();
                }
                session.write((Object)((WritePointImpl)writePoint).getBuffer());
            } else {
                this.log.debug((Object)"Attempt to write while connection is closed, request is queued");
                List<ByteBuffer> list = this.pendingWrites;
                synchronized (list) {
                    this.pendingWrites.add(((WritePointImpl)writePoint).getBuffer());
                }
            }
        } else {
            throw new IllegalArgumentException("Incompatible WritePoint, mixing connection implementation?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePendingData() {
        IoSession session = this.connection.getSession();
        List<ByteBuffer> list = this.pendingWrites;
        synchronized (list) {
            if (this.pendingWrites.isEmpty()) {
                return;
            }
            this.log.debug((Object)"Writing queued requests...");
            for (ByteBuffer bb : this.pendingWrites) {
                session.write((Object)bb);
            }
            this.pendingWrites.clear();
        }
    }

    public WritePoint createWritePoint() {
        return new WritePointImpl();
    }

    public void close(Throwable closeReason) {
    }

    static class WritePointImpl
    implements WritePoint {
        private ByteBuffer buffer = ByteBuffer.allocate((int)1024);

        public WritePointImpl() {
            this.buffer.setAutoExpand(true);
        }

        public void write(byte[] bytes) {
            this.buffer.put(bytes);
        }

        public void write(byte[] bytes, int offset, int len) {
            this.buffer.put(bytes, offset, len);
        }

        public ByteBuffer getBuffer() {
            this.buffer.flip();
            return this.buffer;
        }
    }
}

