/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.mux;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.impl.AbstractConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.Command;
import com.genesyslab.platform.commons.connection.impl.CommandQueue;
import com.genesyslab.platform.commons.connection.impl.CommandQueueListImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.mux.SelectorManager;
import com.genesyslab.platform.commons.connection.impl.mux.SelectorWritePipeImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.threading.AsyncInvoker;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class MultiplexingConnectionImpl
extends AbstractConnectionImpl
implements Connection,
ConnectionImpl {
    private final ILogger log = Log.getLogger(MultiplexingConnectionImpl.class);
    private static final int DEF_BUF_CAPACITY = 4096;
    private SocketChannel channel;
    private final SelectorWritePipeImpl writePipe = new SelectorWritePipeImpl(this);
    private SelectionKey selKey;
    private ByteBuffer outputData;
    private AllowRead allowReadCommand = new AllowRead();
    private CommandQueue dataQueue = new CommandQueueListImpl();
    private ByteBuffer dataBuffer = ByteBuffer.allocate(4096);
    private int rejectedWrites = 0;

    public void open() {
        AsyncInvoker invoker = this.getInvoker();
        if (invoker == null) {
            this.doOpen();
        } else {
            invoker.invoke(new Runnable(){

                public void run() {
                    MultiplexingConnectionImpl.this.doOpen();
                }
            });
        }
    }

    private void doOpen() {
        super.open();
        try {
            boolean connected;
            this.log.debugFormat("Opening MuxConnection ''{0}''", (Object)this);
            this.setConnectionState(ConnectionState.OPENING);
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.configureLocalEndpoint();
            if (this.address == null) {
                this.address = new InetSocketAddress(this.host, this.port);
            }
            if (connected = this.channel.connect(this.address)) {
                SelectorManager.registerConnectedChannel(this.channel, this);
            } else {
                SelectorManager.registerChannel(this.channel, this);
            }
            SelectorManager.getSelector().wakeup();
        }
        catch (IOException e) {
            this.log.debug((Object)("Failed to connect to SocketChannel '" + this), (Throwable)e);
            this.forceClose(e);
            return;
        }
        catch (IllegalStateException e) {
            this.log.debug((Object)("Failed to connect to SocketChannel '" + this), (Throwable)e);
            this.forceClose(e);
            return;
        }
        catch (IllegalArgumentException e) {
            this.log.debug((Object)("Failed to connect to SocketChannel '" + this), (Throwable)e);
            this.forceClose(e);
            return;
        }
        this.log.debugFormat("Connection sequence initiated for {0}", (Object)this);
    }

    public void attach(SocketChannel channel) throws IOException {
        this.setConnectionState(ConnectionState.OPENING);
        this.log.debugFormat("Attaching to io channel : {0} on connection ''{1}''", (Object)new Object[]{channel, this});
        this.channel = channel;
        channel.configureBlocking(false);
        Socket socket = channel.socket();
        InetAddress inetAddress = socket.getInetAddress();
        this.host = inetAddress.getHostName();
        this.port = socket.getPort();
        this.address = new InetSocketAddress(inetAddress, this.port);
        this.setConnectionState(ConnectionState.OPENED);
    }

    public WritePipe getWritePipe() {
        return this.writePipe;
    }

    public ByteBuffer getOutputData() {
        if (this.outputData == null || this.outputData.remaining() == 0) {
            try {
                Command cmd = this.dataQueue.get();
                if (cmd == null) {
                    return null;
                }
                this.outputData = (ByteBuffer)cmd.execute();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
        return this.outputData;
    }

    public SocketChannel getChannel() {
        return this.channel;
    }

    public CommandQueue getDataQueue() {
        return this.dataQueue;
    }

    protected void startClose(Throwable closeReason) {
        this.writePipe.close(closeReason);
    }

    protected void doClose(Throwable closeReason) {
        this.log.debugFormat("Closing MConnection: {0}", (Object)this);
        try {
            if (this.channel != null) {
                this.channel.close();
                this.channel = null;
            }
            if (this.selKey != null) {
                this.selKey.cancel();
                SelectorManager.getSelector().wakeup();
            }
        }
        catch (IOException e) {
            this.log.debug((Object)("IO failure closing SocketChannel '" + this), (Throwable)e);
        }
        super.doClose(closeReason);
    }

    protected void onSocketConnected(SelectionKey key) {
        this.setConnectionState(ConnectionState.OPENED);
        this.notifyEstablishedHandler();
        this.selKey = key;
    }

    protected void onDataReady() throws IOException, InvalidPacketException {
        AsyncInvoker invoker = this.getInvoker();
        if (invoker == null) {
            this.processData();
        } else {
            this.selKey.interestOps(this.selKey.interestOps() & 0xFFFFFFFE);
            invoker.invoke(new Runnable(){

                public void run() {
                    MultiplexingConnectionImpl.this.processData();
                    SelectorManager.getManagementQueue().put(MultiplexingConnectionImpl.this.allowReadCommand);
                    MultiplexingConnectionImpl.this.selKey.selector().wakeup();
                }
            });
        }
    }

    protected SocketAddress getSocketAddress() {
        return this.address;
    }

    private void configureLocalEndpoint() throws IOException {
        if (this.config == null || this.channel == null) {
            return;
        }
        Socket socket = this.channel.socket();
        if (socket == null) {
            return;
        }
        String host = this.config.getOption("transport-address");
        Integer port = this.config.getInteger("transport-port");
        if (host == null && port == null) {
            return;
        }
        int bindPort = 0;
        if (port != null) {
            bindPort = port;
        }
        InetSocketAddress address = host == null ? new InetSocketAddress(bindPort) : new InetSocketAddress(host, bindPort);
        this.log.debugFormat("Binding local endpoint to {0}", (Object)address);
        socket.bind(address);
    }

    public InetSocketAddress getRemoteEndPoint() {
        SocketAddress sa = null;
        if (this.channel != null && this.channel.socket() != null) {
            sa = this.channel.socket().getRemoteSocketAddress();
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    public InetSocketAddress getLocalEndPoint() {
        SocketAddress sa = null;
        if (this.channel != null && this.channel.socket() != null) {
            sa = this.channel.socket().getLocalSocketAddress();
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processData() {
        byte[] bytes = null;
        try {
            int cnt = this.channel.read(this.dataBuffer);
            if (cnt < 0) {
                throw new IOException("End of stream, connection closed by peer '" + this);
            }
            if (cnt == 0) {
                return;
            }
            if (this.dataBuffer.hasArray()) {
                bytes = this.dataBuffer.array();
            } else {
                bytes = new byte[cnt];
                this.dataBuffer.get(bytes);
            }
            this.getMessageTransport().processData(bytes, 0, cnt);
        }
        catch (InvalidPacketException e) {
            if (null != bytes) {
                String hexDump = MultiplexingConnectionImpl.bytesToHexDump(bytes);
                this.log.debug((Object)("Invalid packet encountered on \"" + this + "\": " + hexDump), (Throwable)((Object)e));
            }
        }
        catch (IOException e) {
            this.log.debug((Object)("IO Error reading data '" + this), (Throwable)e);
            this.forceClose(e);
        }
        finally {
            this.dataBuffer.rewind();
        }
    }

    public void processRejectedWrite() {
        ++this.rejectedWrites;
        if (this.rejectedWrites % 999 == 0 && this.log.isDebug()) {
            this.log.debug((Object)("Too much rejected writes: " + this.rejectedWrites));
        }
    }

    public void resetRejectedWrite() {
        if (this.rejectedWrites > 0) {
            this.rejectedWrites = 0;
        }
    }

    private class AllowRead
    implements Command {
        private AllowRead() {
        }

        public Object execute() {
            if (MultiplexingConnectionImpl.this.selKey.isValid()) {
                MultiplexingConnectionImpl.this.selKey.interestOps(MultiplexingConnectionImpl.this.selKey.interestOps() | 1);
            } else {
                MultiplexingConnectionImpl.this.log.debugFormat("Invalid key in AllowRead, closing connection {0}", (Object)MultiplexingConnectionImpl.this);
                MultiplexingConnectionImpl.this.close(new CancelledKeyException());
            }
            return null;
        }
    }
}

