/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.mux;

import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.impl.Command;
import com.genesyslab.platform.commons.connection.impl.CommandQueue;
import com.genesyslab.platform.commons.connection.impl.CommandQueueListImpl;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.mux.MultiplexingAcceptor;
import com.genesyslab.platform.commons.connection.impl.mux.MultiplexingConnectionImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.threading.ThreadHeartbeatCounter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public final class SelectorManager {
    private static final ILogger log = Log.getLogger(SelectorManager.class);
    private static final ILogger dataLog = Log.getLogger((String)"com.genesyslab.platform.internal.con.data");
    private static volatile int threadCounter = 0;
    private static Selector selector;
    private static final CommandQueue managementQueue;

    private SelectorManager() {
    }

    public static synchronized Selector getSelector() throws IllegalStateException {
        if (selector == null || !selector.isOpen()) {
            selector = SelectorManager.createSelector();
        }
        if (selector == null) {
            throw new PsdkConnectionException("Selector is not open, check your network configuration");
        }
        return selector;
    }

    public static CommandQueue getManagementQueue() {
        return managementQueue;
    }

    public static void addInterest(SelectableChannel chn, int interest, Object attachment) throws ClosedChannelException {
        Selector sel = SelectorManager.getSelector();
        SelectionKey key = chn.keyFor(sel);
        if (key == null) {
            chn.register(sel, interest, attachment);
        } else {
            if (!key.isValid()) {
                return;
            }
            int oldInterest = key.interestOps();
            int newInterest = oldInterest | interest;
            key.interestOps(newInterest);
            key.attach(attachment);
        }
    }

    static synchronized void registerChannel(SocketChannel channel, Object attachment) {
        SelectorManager.getManagementQueue().put(new RegForConnectCommand(SelectorManager.getSelector(), channel, attachment));
        SelectorManager.startThreads();
    }

    static synchronized void registerConnectedChannel(SocketChannel channel, MultiplexingConnectionImpl attachment) {
        SelectorManager.getManagementQueue().put(new RegReadWriteCommand(SelectorManager.getSelector(), channel, attachment));
        SelectorManager.startThreads();
    }

    public static void registerServerChannel(ServerSocketChannel channel, MultiplexingAcceptor acceptor) {
        SelectorManager.getManagementQueue().put(new RegForAcceptCommand(SelectorManager.getSelector(), channel, acceptor));
        SelectorManager.startThreads();
    }

    private static Selector createSelector() {
        Selector sel = null;
        try {
            sel = Selector.open();
        }
        catch (IOException e) {
            log.error((Object)"Failed to open Selector", (Throwable)e);
        }
        return sel;
    }

    protected static synchronized void startThreads() {
        if (threadCounter > 0) {
            if (selector != null) {
                selector.wakeup();
            }
            return;
        }
        log.debug((Object)"Starting selector thread");
        Thread thread = new Thread((Runnable)new SelectorThread(), "Selector#" + threadCounter++);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void terminateSelector() {
        --threadCounter;
        try {
            log.debug((Object)"Closing Selector");
            selector.close();
        }
        catch (IOException e) {
            log.debug((Object)"Failure closing Selector", (Throwable)e);
        }
        finally {
            selector = null;
        }
    }

    static {
        managementQueue = new CommandQueueListImpl();
    }

    private static class RegForAcceptCommand
    implements Command {
        private Selector selector;
        private ServerSocketChannel channel;
        private Object attachment;

        public RegForAcceptCommand(Selector selector, ServerSocketChannel channel, Object attachment) {
            this.selector = selector;
            this.channel = channel;
            this.attachment = attachment;
        }

        public Object execute() {
            try {
                log.debugFormat("Registering channel for accept: {0}", (Object)this.channel);
                this.channel.register(this.selector, 16, this.attachment);
            }
            catch (ClosedChannelException e) {
                log.debug((Object)"Channel is closed while trying to register for connect", (Throwable)e);
            }
            return null;
        }
    }

    private static class RegReadWriteCommand
    implements Command {
        private Selector selector;
        private SelectableChannel channel;
        private MultiplexingConnectionImpl connection;

        public RegReadWriteCommand(Selector selector, SelectableChannel channel, MultiplexingConnectionImpl connection) {
            this.selector = selector;
            this.channel = channel;
            this.connection = connection;
        }

        public Object execute() {
            try {
                if (log.isDebug()) {
                    log.debug((Object)("Registering connected channel: " + this.channel));
                }
                SelectionKey key = this.channel.register(this.selector, 5, this.connection);
                this.connection.onSocketConnected(key);
            }
            catch (ClosedChannelException e) {
                log.debug((Object)"Channel is closed while trying to register for read/write", (Throwable)e);
            }
            return null;
        }
    }

    private static class RegForConnectCommand
    implements Command {
        private Selector selector;
        private SelectableChannel channel;
        private Object attachment;

        public RegForConnectCommand(Selector selector, SelectableChannel channel, Object attachment) {
            this.selector = selector;
            this.channel = channel;
            this.attachment = attachment;
        }

        public Object execute() {
            try {
                if (log.isDebug()) {
                    log.debug((Object)("Registering channel for connect: " + this.channel));
                }
                this.channel.register(this.selector, 8, this.attachment);
            }
            catch (ClosedChannelException e) {
                log.debug((Object)"Channel is closed while trying to register for connect", (Throwable)e);
            }
            return null;
        }
    }

    private static class SelectorThread
    implements Runnable {
        private boolean stopped = false;
        private ThreadHeartbeatCounter monitor = null;

        private SelectorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    this.monitor = ThreadHeartbeatCounter.createThreadHeartbeatCounter((String)"MUXSelectorThread", (int)1);
                    this.monitor.initialize();
                }
                catch (Exception ex) {
                    log.error((Object)"Exception while creating thread monitor", (Throwable)ex);
                }
                this.selectorLoop();
            }
            finally {
                log.debug((Object)"Terminating selector thread");
                SelectorManager.terminateSelector();
                if (this.monitor != null) {
                    this.monitor.unregister();
                    this.monitor = null;
                }
            }
        }

        private void selectorLoop() {
            while (!this.stopped) {
                try {
                    int readyCnt = selector.select(500L);
                    if (this.monitor != null) {
                        this.monitor.alive();
                    }
                    if (readyCnt > 0) {
                        this.processKeys();
                    }
                    SelectorThread.processQueues();
                    if (!selector.keys().isEmpty()) continue;
                    break;
                }
                catch (IOException e) {
                    log.warn((Object)"IO failure in selector loop", (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"interrupted in selector loop", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.warn((Object)"Unhandled exception in selector loop", (Throwable)e);
                }
                catch (Throwable e) {
                    log.error((Object)"Critical failure in selector loop, terminating", e);
                    this.failureClose(e);
                    return;
                }
            }
        }

        private void failureClose(Throwable e) {
            for (SelectionKey selectionKey : selector.keys()) {
                this.forseCloseConnection(selectionKey, e);
            }
        }

        public void shutdown() {
            this.stopped = true;
            selector.wakeup();
        }

        private void processKeys() {
            Iterator<SelectionKey> keys = selector.selectedKeys().iterator();
            while (keys.hasNext()) {
                SelectionKey key = keys.next();
                this.processSingleKeySafe(key);
                keys.remove();
            }
        }

        private static void processQueues() throws InterruptedException {
            CommandQueue cmdQueue = SelectorManager.getManagementQueue();
            Command cmd = cmdQueue.get();
            while (cmd != null) {
                cmd.execute();
                cmd = cmdQueue.get();
            }
        }

        private void processSingleKeySafe(SelectionKey key) {
            try {
                this.processSingleKey(key);
            }
            catch (IOException e) {
                MultiplexingConnectionImpl conn = SelectorThread.getConnection(key);
                key.cancel();
                if (log.isWarn()) {
                    log.warn((Object)("IO failure for connection '" + conn), (Throwable)e);
                }
                conn.forceClose(e);
            }
            catch (CancelledKeyException e) {
                log.debug((Object)"Canceled key, connection closed by peer?");
                if (key.attachment() != null) {
                    this.closeConnection(key, e);
                }
            }
            catch (IllegalStateException e) {
                log.debug((Object)"Connection related problems");
                if (key.attachment() != null) {
                    this.closeConnection(key, e);
                }
            }
            catch (InvalidPacketException e) {
                if (log.isWarn()) {
                    log.warn((Object)("Bad packet encountered '" + key), (Throwable)((Object)e));
                }
            }
            catch (Throwable e) {
                if (log.isWarn()) {
                    log.warn((Object)("Failure in connection. Trying to close. '" + key.attachment()), e);
                }
                this.forseCloseConnection(key, e);
                throw new Error("Critical failure in connection", e);
            }
        }

        private void closeConnection(SelectionKey key, Exception e) {
            Object connection = key.attachment();
            if (connection instanceof MultiplexingConnectionImpl) {
                ((MultiplexingConnectionImpl)connection).close(e);
            } else if (connection instanceof MultiplexingAcceptor) {
                ((MultiplexingAcceptor)connection).close();
            }
        }

        private void forseCloseConnection(SelectionKey key, Throwable e) {
            Object connection = key.attachment();
            log.debugFormat("Force closing {0}", connection);
            if (connection instanceof MultiplexingConnectionImpl) {
                ((MultiplexingConnectionImpl)connection).forceClose(e);
            } else if (connection instanceof MultiplexingAcceptor) {
                ((MultiplexingAcceptor)connection).close();
            }
        }

        private void processSingleKey(SelectionKey key) throws IOException, InvalidPacketException {
            boolean processed = false;
            if (key.isAcceptable()) {
                this.processAcception(key);
                return;
            }
            if (key.isConnectable()) {
                this.processConnection(key);
                processed = true;
            }
            if (key.isWritable()) {
                this.processOutput(key);
                processed = true;
            }
            if (key.isReadable()) {
                this.processInput(key);
                processed = true;
            }
            if (!processed) {
                log.debug((Object)("Unprocessed key: " + key.readyOps()));
            }
        }

        private void processAcception(SelectionKey key) {
            ServerSocketChannel ch = (ServerSocketChannel)key.channel();
            try {
                if (ch.isOpen()) {
                    SocketChannel newChannel = ch.accept();
                    MultiplexingAcceptor acceptor = (MultiplexingAcceptor)key.attachment();
                    acceptor.handleConnection(newChannel);
                } else {
                    log.debug((Object)"Server socket is closed, canceling key!");
                    key.cancel();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Failed to accept connection", (Throwable)e);
            }
        }

        private void processConnection(SelectionKey key) throws IOException {
            log.debug((Object)"Processing connection key");
            SocketChannel channel = (SocketChannel)key.channel();
            if (channel.isConnectionPending()) {
                if (channel.finishConnect()) {
                    MultiplexingConnectionImpl connImpl = SelectorThread.getConnection(key);
                    connImpl.onSocketConnected(key);
                    key.interestOps(5);
                } else {
                    log.debugFormat("Failed to finnish connect for [{0}]", (Object)channel);
                }
            } else if (!channel.isConnected()) {
                log.debugFormat("Trying to connect once more for [{0}]", (Object)channel);
                MultiplexingConnectionImpl connImpl = SelectorThread.getConnection(key);
                channel.connect(connImpl.getSocketAddress());
            }
        }

        private void processInput(SelectionKey key) throws IOException, InvalidPacketException {
            MultiplexingConnectionImpl connImpl = SelectorThread.getConnection(key);
            connImpl.onDataReady();
        }

        private void processOutput(SelectionKey key) throws IOException {
            MultiplexingConnectionImpl conn = SelectorThread.getConnection(key);
            ByteBuffer data = conn.getOutputData();
            if (data != null) {
                SocketChannel channel = (SocketChannel)key.channel();
                long bytesWritten = channel.write(data);
                if (bytesWritten == 0L) {
                    conn.processRejectedWrite();
                } else {
                    conn.resetRejectedWrite();
                    if (dataLog.isDebug()) {
                        dataLog.debug((Object)("bytes written: " + bytesWritten + " to '" + channel));
                    }
                }
            } else if (key.isValid()) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
            }
        }

        private static MultiplexingConnectionImpl getConnection(SelectionKey key) {
            return (MultiplexingConnectionImpl)key.attachment();
        }
    }
}

