/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.xml;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.MessageProducer;
import com.genesyslab.platform.commons.connection.impl.xml.ProtocolDialect;
import com.genesyslab.platform.commons.connection.impl.xml.XmlStructureHandler;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlMessageProducerImpl
implements MessageProducer {
    private static final String HEADER = "header";
    private static final String ENVELOPE = "envelope";
    private static final String BODY = "body";
    private static final String TEXT = "text";
    private static ILogger log = Log.getLogger(XmlMessageProducerImpl.class);
    private byte[] buf;
    private int pos;
    private int len;
    private MessagePackager packager;
    private ProtocolDialect dialect;

    public XmlMessageProducerImpl(byte[] b, int pos, int len, MessagePackager packager) {
        this.buf = new byte[len];
        System.arraycopy(b, pos, this.buf, 0, len);
        this.pos = 0;
        this.len = len;
        this.packager = packager;
    }

    public void setDialect(ProtocolDialect dialect) {
        this.dialect = dialect;
    }

    public void parse() throws InvalidPacketException {
        if (this.dialect == null) {
            throw new PsdkConnectionException("MessageProducer is not initialized");
        }
        try {
            Document doc = this.parseData();
            Element envelope = doc.getDocumentElement();
            Element body = this.validateMessage(envelope);
            this.parseMessage(XmlUtil.getFirstChild((Element)body));
        }
        catch (PlatformException e) {
            log.warn((Object)"Problems packaging xml message", (Throwable)e);
        }
    }

    protected void parseMessage(Element messageElement) throws PlatformException {
        if (messageElement == null) {
            throw new PlatformException("empty body");
        }
        String messageName = messageElement.getNodeName();
        int msgId = this.dialect.getMessageId(messageName);
        Object state = this.packager.onNewMessage(null, msgId);
        this.parseSimpleData(messageElement, state);
        this.parseComplexData(messageElement, state);
        this.packager.onMessageEnd(state);
    }

    private void parseSimpleData(Element element, Object state) throws PlatformException {
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            this.packager.onAttribute(state, attr.getName(), attr.getValue());
        }
        String text = XmlUtil.getElementText((Element)element);
        if (text != null && !"".equals(text)) {
            this.packager.onAttribute(state, TEXT, text);
        }
    }

    private void parseComplexData(Element complexData, Object packagerState) throws PlatformException {
        Element nestedData = XmlUtil.getFirstChild((Element)complexData);
        while (nestedData != null) {
            this.processComplexElement(nestedData, packagerState);
            nestedData = XmlUtil.getNextSibling((Element)nestedData);
        }
    }

    private void processComplexElement(Element nestedData, Object packagerState) throws PlatformException {
        XmlStructureHandler xmlStructureHandler = null;
        boolean isXml = this.packager instanceof XmlStructureHandler;
        boolean needsProcessing = false;
        String nodeName = nestedData.getNodeName();
        Object currentState = packagerState;
        if (isXml) {
            xmlStructureHandler = (XmlStructureHandler)((Object)this.packager);
            currentState = xmlStructureHandler.onComplexAttribute(packagerState, nodeName, nestedData);
            needsProcessing = xmlStructureHandler.needsProcessing(packagerState, nodeName, nestedData);
        }
        if (needsProcessing) {
            this.parseSimpleData(nestedData, currentState);
            this.parseComplexData(nestedData, currentState);
        }
        if (isXml) {
            xmlStructureHandler.onComplexEnd(packagerState, nodeName);
        }
    }

    private Element validateMessage(Element envelope) throws PlatformException {
        if (!ENVELOPE.equals(envelope.getNodeName())) {
            throw new PlatformException("envelope element expected");
        }
        Element header = XmlUtil.getFirstChild((Element)envelope);
        if (!HEADER.equals(header.getNodeName())) {
            throw new PlatformException("header not found as the first child of envelope");
        }
        this.dialect.validateHeader(header);
        Element body = XmlUtil.getNextSibling((Element)header);
        if (!BODY.equals(body.getNodeName())) {
            throw new PlatformException("body not found as second child of envelope");
        }
        return body;
    }

    private Document parseData() throws PlatformException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.fixEncoding();
            if (log.isDebug()) {
                String encoding = "UTF-16";
                if (this.buf[this.pos] != 0) {
                    encoding = "UTF-16LE";
                }
                log.debug((Object)("Parsing: " + new String(this.buf, this.pos, this.len, encoding)));
            }
            return docBuilder.parse(new ByteArrayInputStream(this.buf, this.pos, this.len));
        }
        catch (Exception e) {
            throw new PlatformException("Failed to parse xml message", (Throwable)e);
        }
    }

    private void fixEncoding() {
        boolean badTail;
        int lastIndex = this.pos + this.len - 1;
        boolean bl = badTail = this.buf[lastIndex] == 0 && this.buf[lastIndex - 1] == 0;
        if (badTail) {
            this.len -= 2;
        }
    }
}

