/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.interceptor;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionException;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.configuration.ClientADDPOptions;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.ShiftByteArrayOutputStream;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.connection.interceptor.Interceptor;
import com.genesyslab.platform.commons.connection.interceptor.InterceptorImpl;
import com.genesyslab.platform.commons.connection.interceptor.NoInterceptorImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.timer.Scheduler;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;

public class AddpInterceptor
extends NoInterceptorImpl
implements InterceptorImpl {
    public static final String NAME = "addp";
    public static final int ADDP_VERSION = 512;
    public static final String TIMEOUT_KEY = "addp-timeout";
    public static final String REMOTE_TIMEOUT_KEY = "addp-remote-timeout";
    public static final String TRACE_KEY = "addp-trace";
    public static final String ACTIVE_KEY = "x-addp-active";
    private final ILogger log = Log.getLogger(AddpInterceptor.class);
    private final ILogger addpLog = Log.getLogger((String)"ADDP");
    private static final int PACKET_SIZE = 6;
    private static final byte ADDP_SIGNATURE_0 = 112;
    private static final byte ADDP_SIGNATURE_1 = 50;
    private static final int ADDP_TRACE_FLAG = 0x800000;
    private final Object timersSync = new Object();
    private TimerActionTicket pollTicket;
    private ConnectionImpl conn;
    private NoInterceptorImpl noProtocol = new NoInterceptorImpl();
    private long timeout;
    private long remoteTimeout;
    private boolean remoteTrace = false;
    private boolean started = false;
    private boolean active = true;
    private TimerAction pollAction = new PollAction();
    private TimerAction disconnectAction = new DisconnectAction();
    private int pollId = 0;
    private boolean connectionIdle = false;
    private final Scheduler timer = TimerFactory.getTimer();
    private volatile boolean suppressed;
    private boolean localTrace = false;
    private int remoteVersion = 0;

    public AddpInterceptor(ConnectionImpl conn) {
        this.conn = conn;
    }

    public int getRemoteVersion() {
        return this.remoteVersion;
    }

    public void executeCommand(Interceptor.Command command) {
        if (!(command instanceof AddpCommand)) {
            throw new IllegalArgumentException("Not an addp command");
        }
        AddpCommand addpCommand = (AddpCommand)command;
        addpCommand.setInterceptor(this);
        addpCommand.execute();
    }

    public void configure(ConnectionConfiguration config) {
        ClientADDPOptions.AddpTraceMode traceMode;
        boolean newRemoteTrace;
        boolean changedLocalConfiguration = false;
        boolean changedRemoteConfiguration = false;
        long newTimeout = this.getTimeout(config, TIMEOUT_KEY, this.timeout, true);
        boolean changeLocalTimeout = this.timeout != newTimeout;
        changedLocalConfiguration |= changeLocalTimeout;
        long newRemoteTimeout = this.getTimeout(config, REMOTE_TIMEOUT_KEY, this.remoteTimeout, false);
        changedRemoteConfiguration |= this.remoteTimeout != newRemoteTimeout;
        String strTraceMode = null;
        if (config != null) {
            strTraceMode = config.getOption(TRACE_KEY);
        }
        changedRemoteConfiguration |= this.remoteTrace != (newRemoteTrace = (traceMode = ClientADDPOptions.AddpTraceMode.parse(strTraceMode)).traceRemote());
        boolean newLocalTrace = traceMode.traceLocal();
        changedLocalConfiguration |= this.localTrace != newLocalTrace;
        String activeOption = null;
        if (config != null) {
            activeOption = config.getOption(ACTIVE_KEY);
        }
        boolean newActive = !"false".equals(activeOption);
        changedLocalConfiguration |= this.active != newActive;
        String protoName = config.getOption("protocol");
        boolean addp = NAME.equals(protoName);
        if ((changedLocalConfiguration |= this.started != addp) || changedRemoteConfiguration) {
            if (this.started) {
                this.logConfigure(config);
            }
            this.timeout = newTimeout;
            this.remoteTimeout = newRemoteTimeout;
            this.remoteTrace = newRemoteTrace;
            this.localTrace = newLocalTrace;
            this.active = newActive;
        }
        if (!this.started) {
            if (addp) {
                this.logConfigure(config);
                this.start();
            }
        } else if (!addp) {
            this.stop();
        } else {
            if (changedRemoteConfiguration) {
                this.sendReconfigPacket();
            }
            if (changeLocalTimeout) {
                this.restartTimer();
            }
        }
    }

    private void logConfigure(ConnectionConfiguration config) {
        this.log.debugFormat("Configuring ADDP with: {0}", (Object)config);
        if (this.localTrace) {
            this.addpLog.debugFormat("Configuring ADDP with: {0}", (Object)config);
        }
    }

    public void start() {
        this.started = true;
        if (this.active) {
            this.sendInitPacket();
            this.restartTimer();
        }
    }

    public void stop() {
        if (this.started) {
            this.started = false;
            this.stopTimer();
            if (this.active) {
                this.sendPacket('R', 0);
            }
        }
    }

    public void dispose() {
        this.stopTimer();
    }

    public boolean isSuppressed() {
        return this.suppressed;
    }

    public void setSuppressed(boolean suppressed) {
        if (this.suppressed != suppressed) {
            if (suppressed) {
                this.log.debugFormat("ADDP is now suppressed for connection {0}", (Object)this.conn);
            } else {
                this.log.debugFormat("ADDP suppression is now removed for connection {0}", (Object)this.conn);
            }
        }
        this.suppressed = suppressed;
    }

    public int getPacketLength(byte[] buffer, int offset, int len) {
        if (this.active) {
            this.restartTimer();
        }
        if (len < 4) {
            return 0;
        }
        if (this.isAddpPacket(buffer, offset)) {
            if (len < 6) {
                return 0;
            }
            if (this.log.isDebug()) {
                this.log.debug((Object)("Addp packet received: " + (char)buffer[2] + "(" + AddpInterceptor.getPacketData(buffer) + ") from " + this.conn));
            }
            if (this.addpLog.isInfo() && this.localTrace) {
                this.addpLog.info((Object)("Addp packet received: " + (char)buffer[2] + "(" + AddpInterceptor.getPacketData(buffer) + ") from " + this.conn));
            }
            return 6;
        }
        return this.noProtocol.getPacketLength(buffer, offset, len);
    }

    private boolean isAddpPacket(byte[] src, int offset) {
        return src[offset] == 112 && src[offset + 1] == 50;
    }

    public boolean processPacket(ShiftByteArrayOutputStream stream, int packetLen) {
        byte[] bytes = stream.getBuffer();
        if (this.isAddpPacket(bytes, 0)) {
            this.processAddpPacket(bytes);
            stream.shiftBack(packetLen);
            return true;
        }
        return this.noProtocol.processPacket(stream, packetLen);
    }

    private void processAddpPacket(byte[] bytes) {
        char packetType = (char)bytes[2];
        int packetData = AddpInterceptor.getPacketData(bytes);
        switch (packetType) {
            case 'p': {
                break;
            }
            case 'P': {
                this.sendPacket('p', packetData);
                if (this.log.isInfo() && this.localTrace) {
                    this.log.info((Object)("Addp packet sent: p(" + packetData + ") to " + this.conn));
                    break;
                }
                if (!this.log.isDebug()) break;
                this.log.debug((Object)("Addp packet sent: p(" + packetData + ") to " + this.conn));
                break;
            }
            case 'X': {
                if (packetData != 0) {
                    this.suspendAddp(packetData);
                    break;
                }
                this.resumeAddp();
                break;
            }
            case 'R': {
                this.sendPacket('r', (int)this.timeout);
                this.active = true;
                this.unpackAddpData(packetData);
                break;
            }
            case 'r': {
                break;
            }
            case 'I': {
                this.sendPacket('i', this.conn.hashCode());
                this.active = true;
                this.unpackAddpData(packetData);
                this.restartTimer();
                break;
            }
            case 'i': {
                break;
            }
            case 'V': {
                this.sendPacket('v', 512);
                this.remoteVersion = packetData;
                break;
            }
            default: {
                if (!this.log.isWarn()) break;
                this.log.warn((Object)("Strange ADDP packet. Type: " + packetType + " from " + this.conn));
            }
        }
    }

    private void unpackAddpData(int packetData) {
        this.localTrace = (packetData & 0x800000) != 0;
        long newTimeout = packetData;
        if (this.localTrace) {
            newTimeout &= 0xFFFFFFFFFF7FFFFFL;
        }
        this.timeout = newTimeout;
        if (this.log.isDebug()) {
            this.log.debugFormat("New timeout: {0}; trace: {1}", (Object)new Object[]{this.timeout, this.localTrace});
        }
    }

    private static int getPacketData(byte[] bytes) {
        return (0xFF0000 & bytes[3] << 16) + (0xFF00 & bytes[4] << 8) + (0xFF & bytes[5]);
    }

    private long getTimeout(ConnectionConfiguration config, String name, long defaultTimeout, boolean localTimeout) {
        String str = null;
        if (config != null) {
            str = config.getOption(name);
        }
        if (str == null) {
            return defaultTimeout;
        }
        try {
            float f = Float.parseFloat(str);
            long t = (long)(f * 1000.0f);
            if (t > 0L && t < 1000L) {
                if (this.log.isDebug()) {
                    this.log.debugFormat("ADDP {1} timeout [{0}] is very low. Default timeout 1000ms will be used.", (Object)new Object[]{t, localTimeout ? "local" : "remote"});
                }
                t = 1000L;
            }
            return t;
        }
        catch (NumberFormatException ignore) {
            return -1L;
        }
    }

    private void sendInitPacket() {
        if (this.log.isDebug()) {
            this.log.debug((Object)("Sending init packet. Remote timeout: " + this.remoteTimeout + " for " + this.conn));
        }
        if (this.addpLog.isInfo() && this.localTrace) {
            this.addpLog.info((Object)("Sending init packet. Remote timeout: " + this.remoteTimeout + " for " + this.conn));
        }
        int data = (int)this.remoteTimeout;
        if (this.remoteTrace) {
            data |= 0x800000;
        }
        this.sendPacket('I', data);
    }

    private void sendReconfigPacket() {
        if (this.log.isDebug()) {
            this.log.debug((Object)("Sending reconfiguration packet. Remote timeout: " + this.remoteTimeout + " for " + this.conn));
        }
        if (this.addpLog.isInfo() && this.localTrace) {
            this.addpLog.info((Object)("Sending reconfiguration packet. Remote timeout: " + this.remoteTimeout + " for " + this.conn));
        }
        int data = (int)this.remoteTimeout;
        if (this.remoteTrace) {
            data |= 0x800000;
        }
        this.sendPacket('R', data);
    }

    private void sendPacket(char packetType, int data) {
        byte[] packetBuffer = new byte[]{112, 50, (byte)packetType, (byte)((data & 0xFFFFFF) >> 16 & 0xFF), (byte)((data & 0xFFFFFF) >> 8 & 0xFF), (byte)(data & 0xFF)};
        WritePipe writePipe = this.conn.getWritePipe();
        WritePoint writePoint = writePipe.createWritePoint();
        writePoint.write(packetBuffer);
        writePipe.write(writePoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartTimer() {
        Object object = this.timersSync;
        synchronized (object) {
            this.connectionIdle = false;
            if (this.pollTicket != null) {
                this.pollTicket.cancel();
            }
            if (this.started && this.timeout > 0L) {
                this.pollTicket = this.timer.schedule(this.timeout, this.pollAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimer() {
        Object object = this.timersSync;
        synchronized (object) {
            if (this.pollTicket != null) {
                this.pollTicket.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendAddp(long timeout) {
        Object object = this.timersSync;
        synchronized (object) {
            if (this.pollTicket != null) {
                this.pollTicket.cancel();
            }
            this.pollTicket = this.timer.schedule(timeout, (TimerAction)new SuspendAction());
        }
    }

    private void sendXoffPacket(long timeout) {
        if (this.log.isDebug()) {
            this.log.debug((Object)("Sending Xoff. Timeout: " + timeout + " for " + this.conn));
        }
        if (this.addpLog.isInfo() && this.localTrace) {
            this.addpLog.info((Object)("Sending Xoff. Timeout: " + timeout + " for " + this.conn));
        }
        this.sendPacket('X', (int)timeout);
    }

    private void sendXonPacket() {
        this.log.debugFormat("Sending Xon for {0}", (Object)this.conn);
        if (this.localTrace) {
            this.addpLog.infoFormat("Sending Xon for {0}", (Object)this.conn);
        }
        this.sendPacket('X', 0);
    }

    private void resumeAddp() {
        this.restartTimer();
    }

    private void pollConnection() {
        this.log.debugFormat("Polling connection {0}", (Object)this.conn);
        if (this.localTrace) {
            this.addpLog.infoFormat("Polling connection {0}", (Object)this.conn);
        }
        this.sendPacket('P', this.pollId++);
    }

    private class SuspendAction
    implements TimerAction {
        private SuspendAction() {
        }

        public void onTimer() {
            AddpInterceptor.this.resumeAddp();
        }

        public String toString() {
            return "SuspendtAction for '" + AddpInterceptor.this.conn;
        }
    }

    private class DisconnectAction
    implements TimerAction {
        private DisconnectAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimer() {
            Object object = AddpInterceptor.this.timersSync;
            synchronized (object) {
                if (!AddpInterceptor.this.connectionIdle) {
                    return;
                }
                if (!AddpInterceptor.this.active) {
                    return;
                }
                Connection connection = AddpInterceptor.this.conn.getConnection();
                ConnectionState connState = connection.getConnectionState();
                if (ConnectionState.OPENING == connState) {
                    AddpInterceptor.this.log.debugFormat("Connection ''{0}'' is idle, but in OPENING state. Delaying check for one more timeout period.", (Object)AddpInterceptor.this.conn);
                    if (AddpInterceptor.this.timeout > 0L) {
                        AddpInterceptor.this.pollTicket = AddpInterceptor.this.timer.schedule(AddpInterceptor.this.timeout, AddpInterceptor.this.disconnectAction);
                    }
                    return;
                }
                if (ConnectionState.OPENED == connState) {
                    AddpInterceptor.this.log.debugFormat("Closing idle connection ''{0}''", (Object)AddpInterceptor.this.conn);
                    if (AddpInterceptor.this.localTrace) {
                        AddpInterceptor.this.addpLog.infoFormat("Closing idle connection ''{0}''", (Object)AddpInterceptor.this.conn);
                    }
                    AddpInterceptor.this.conn.close((Throwable)((Object)new ConnectionException("connection is unresponsive")));
                }
            }
        }

        public String toString() {
            return "DisconnectAction for '" + AddpInterceptor.this.conn;
        }
    }

    private class PollAction
    implements TimerAction {
        private PollAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimer() {
            if (AddpInterceptor.this.conn.getConnection().getConnectionState() == ConnectionState.CLOSED) {
                return;
            }
            Object object = AddpInterceptor.this.timersSync;
            synchronized (object) {
                if (!AddpInterceptor.this.active) {
                    return;
                }
                if (AddpInterceptor.this.suppressed) {
                    AddpInterceptor.this.log.debugFormat("ADDP polling is suppressed for connection {0}, restarting timer...", (Object)AddpInterceptor.this.conn);
                    AddpInterceptor.this.restartTimer();
                    return;
                }
                if (AddpInterceptor.this.pollTicket != null) {
                    AddpInterceptor.this.pollTicket.cancel();
                }
                AddpInterceptor.this.connectionIdle = true;
                AddpInterceptor.this.pollConnection();
                if (AddpInterceptor.this.timeout > 0L) {
                    AddpInterceptor.this.pollTicket = AddpInterceptor.this.timer.schedule(AddpInterceptor.this.timeout, AddpInterceptor.this.disconnectAction);
                }
            }
        }

        public String toString() {
            return "PollAction for '" + AddpInterceptor.this.conn;
        }
    }

    public static class ResumeCommand
    extends AddpCommand {
        public void execute() {
            if (this.interceptor != null) {
                this.interceptor.sendXonPacket();
            }
        }
    }

    public static class SuspendCommand
    extends AddpCommand {
        private long suspendInterval;

        public SuspendCommand(long suspendInterval) {
            this.suspendInterval = suspendInterval;
        }

        public void execute() {
            if (this.interceptor != null) {
                this.interceptor.sendXoffPacket(this.suspendInterval);
            }
        }
    }

    private static abstract class AddpCommand
    implements Interceptor.Command {
        protected AddpInterceptor interceptor;

        private AddpCommand() {
        }

        public void setInterceptor(Interceptor interceptor) {
            if (interceptor instanceof AddpInterceptor) {
                this.interceptor = (AddpInterceptor)interceptor;
            }
        }

        public abstract void execute();
    }
}

