/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import javax.security.auth.callback.CallbackHandler;

public class KeyStoreFactory {
    private static final ILogger log = Log.getLogger(KeyStoreFactory.class);
    public static final String DEFAULT_CERT_ALIAS = "DefaultCertificate";
    public static final String DEFAULT_TRUST_CERT_ALIAS = "DefaultTrustCertificate";
    public static final char[] DEFAULT_PASSWORD = new char[0];

    private static KeyStore createNamedKeyStore(String keyStoreName, CallbackHandler keyStoreCallbackHandler) throws GeneralSecurityException, IOException {
        KeyStore rawStore = KeyStore.getInstance(keyStoreName);
        Provider provider = rawStore.getProvider();
        KeyStore.CallbackHandlerProtection protection = new KeyStore.CallbackHandlerProtection(keyStoreCallbackHandler);
        KeyStore.Builder builder = KeyStore.Builder.newInstance(keyStoreName, provider, protection);
        KeyStore keyStore = builder.getKeyStore();
        keyStore.load(null, null);
        return keyStore;
    }

    public static KeyStore createPKCS11KeyStore(CallbackHandler keyStoreCallbackHandler) throws GeneralSecurityException, IOException {
        return KeyStoreFactory.createNamedKeyStore("PKCS11", keyStoreCallbackHandler);
    }

    public static KeyStore createMSCAPIRootStore(CallbackHandler keyStoreCallbackHandler) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreFactory.createNamedKeyStore("WINDOWS-ROOT", keyStoreCallbackHandler);
        try {
            KeyStoreFactory.fixSunMSCAPIAliases(ks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ks;
    }

    public static KeyStore createMSCAPIMyStore(CallbackHandler keyStoreCallbackHandler) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStoreFactory.createNamedKeyStore("WINDOWS-MY", keyStoreCallbackHandler);
        try {
            KeyStoreFactory.fixSunMSCAPIAliases(ks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ks;
    }

    public static KeyStore createPEMTrustKeyStore(Certificate trustCert) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        KeyStore.TrustedCertificateEntry trustEntry = new KeyStore.TrustedCertificateEntry(trustCert);
        keyStore.setEntry(DEFAULT_TRUST_CERT_ALIAS, trustEntry, null);
        return keyStore;
    }

    public static KeyStore createPEMCertKeyStore(Certificate[] certChain, PrivateKey key) throws GeneralSecurityException, IOException {
        boolean matches;
        PublicKey pubKey;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        BigInteger privateKeyMod = null;
        BigInteger publicKeyMod = null;
        if (key instanceof RSAPrivateKey) {
            privateKeyMod = ((RSAPrivateKey)key).getModulus();
        }
        if (certChain.length > 0 && certChain[0] instanceof X509Certificate && (pubKey = ((X509Certificate)certChain[0]).getPublicKey()) instanceof RSAPublicKey) {
            publicKeyMod = ((RSAPublicKey)pubKey).getModulus();
        }
        boolean bl = null == privateKeyMod ? null == publicKeyMod : (matches = privateKeyMod.equals(publicKeyMod));
        if (!matches) {
            throw new KeyException("Private key does not match certificate.");
        }
        KeyStore.PrivateKeyEntry certEntry = new KeyStore.PrivateKeyEntry(key, certChain);
        keyStore.setEntry(DEFAULT_CERT_ALIAS, certEntry, new KeyStore.PasswordProtection(DEFAULT_PASSWORD));
        return keyStore;
    }

    public static KeyStore createJKSKeyStore(InputStream jksStream, char[] keyStorePassword) throws GeneralSecurityException, IOException {
        if (null == jksStream) {
            throw new IllegalArgumentException("jksStream must not be empty");
        }
        if (null == keyStorePassword) {
            throw new IllegalArgumentException("keyStorePassword must not be null");
        }
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(jksStream, keyStorePassword);
        return keyStore;
    }

    private static void fixSunMSCAPIAliases(KeyStore keyStore) throws NoSuchFieldException, IllegalAccessException {
        Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
        field.setAccessible(true);
        KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
        String ksName = keyStoreVeritable.getClass().getName();
        if ("sun.security.mscapi.KeyStore$MY".equals(ksName) || "sun.security.mscapi.KeyStore$ROOT".equals(ksName)) {
            field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
            field.setAccessible(true);
            Collection entries = (Collection)field.get(keyStoreVeritable);
            for (Object entry : entries) {
                field = entry.getClass().getDeclaredField("certChain");
                field.setAccessible(true);
                X509Certificate[] certificates = (X509Certificate[])field.get(entry);
                String hashCode = Integer.toString(certificates[0].hashCode());
                field = entry.getClass().getDeclaredField("alias");
                field.setAccessible(true);
                String alias = (String)field.get(entry);
                if (alias.equals(hashCode)) continue;
                field.set(entry, alias.concat(" - ").concat(hashCode));
            }
        }
    }
}

