/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

import com.genesyslab.platform.commons.connection.tls.SSLExtendedOptions;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SSLContextHelper {
    private static final String PROTOCOL_TLS = "tls";

    public static SSLContext createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL_TLS);
        sslContext.init(keyManagers, trustManagers, secureRandom);
        return sslContext;
    }

    public static SSLContext createSSLContext(KeyManager keyManager, TrustManager trustManager) throws GeneralSecurityException {
        return SSLContextHelper.createSSLContext(new KeyManager[]{keyManager}, new TrustManager[]{trustManager}, null);
    }

    public static SSLExtendedOptions createSSLExtendedOptions(boolean mutualTLS, String[] enabledCipherSuites) {
        return new SSLExtendedOptions(mutualTLS, enabledCipherSuites);
    }

    public static SSLExtendedOptions createSSLExtendedOptions(boolean mutualTLS, String enabledCipherSuites) {
        return new SSLExtendedOptions(mutualTLS, enabledCipherSuites);
    }
}

