/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.tls;

class ThumbprintUtils {
    ThumbprintUtils() {
    }

    static boolean isThumbprint(String s) {
        if (null == s || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ThumbprintUtils.isHex(ch) || ThumbprintUtils.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    static void validateThumbprint(String s) throws IllegalArgumentException {
        if (null == s || s.length() == 0) {
            throw new IllegalArgumentException("Thumbprint can not be null or empty");
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ThumbprintUtils.isHex(ch) || ThumbprintUtils.isWhitespace(ch)) continue;
            String hexCh = Integer.toString(ch, 16);
            throw new IllegalArgumentException("Error in thumbprint at position " + (i + 1) + ". Invalid symbol with code 0x" + hexCh + ": \"" + s + "\"");
        }
    }

    static byte[] thumbprintToBytes(String s) {
        int len = (s = ThumbprintUtils.filterThumbprint(s)).length();
        if (len % 2 != 0) {
            s = "0" + s;
            ++len;
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static String filterThumbprint(String s) {
        if (s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!ThumbprintUtils.isHex(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\u000b' || ch == '\f' || ch == '\r';
    }

    static boolean isHex(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
    }
}

