/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.applicationblocks.commons.broker;

import com.genesyslab.platform.applicationblocks.commons.Action;
import com.genesyslab.platform.applicationblocks.commons.Predicate;
import com.genesyslab.platform.applicationblocks.commons.broker.PublishingService;
import com.genesyslab.platform.applicationblocks.commons.broker.Subscriber;
import com.genesyslab.platform.applicationblocks.commons.broker.SubscriptionService;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BrokerServiceBase<T>
implements PublishingService<T>,
SubscriptionService<T> {
    private List<Subscriber<T>> subscribers;
    private final Object subscribersLock = new Object();
    private final ILogger logger = Log.getLogger(this.getClass());

    protected BrokerServiceBase() {
        this(32);
    }

    protected BrokerServiceBase(int capacity) {
        this.subscribers = new LinkedList<Subscriber<T>>();
    }

    @Override
    public void publish(T obj) {
        this.logger.debugFormat("Publishing {0} ...", obj);
        this.onPublish(obj);
        this.logger.debugFormat("Publishing {0} is completed", obj);
    }

    protected void onPublish(T obj) {
        this.notify(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Subscriber<T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("Subscriber is null.");
        }
        Object object = this.subscribersLock;
        synchronized (object) {
            if (this.subscribers.contains(subscriber)) {
                throw new IllegalArgumentException("subscriber: Subscriber is already registered.");
            }
            this.subscribers.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Action<T> handler, Predicate<T> filter) {
        if (handler == null) {
            throw new NullPointerException("handler is null.");
        }
        Object object = this.subscribersLock;
        synchronized (object) {
            for (Subscriber<T> s : this.subscribers) {
                DelegateSubscriber s1;
                if (s == null || !(s instanceof DelegateSubscriber) || (s1 = (DelegateSubscriber)s).getHandler() != handler) continue;
                throw new IllegalArgumentException("handler is already registered.");
            }
            DelegateSubscriber<T> subscriber = new DelegateSubscriber<T>(handler, filter);
            this.subscribers.add(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Subscriber<T> subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("subscriber: Subscriber is null.");
        }
        Object object = this.subscribersLock;
        synchronized (object) {
            if (!this.subscribers.remove(subscriber)) {
                throw new IllegalArgumentException("subscriber: Subscriber is not registered.");
            }
        }
    }

    @Override
    public void unregister(Action<T> handler) {
        if (handler == null) {
            throw new NullPointerException("handler: Handler is null.");
        }
        Object object = this.subscribersLock;
        synchronized (object) {
            for (Subscriber<T> s : this.subscribers) {
                DelegateSubscriber s1;
                if (!(s instanceof DelegateSubscriber) || (s1 = (DelegateSubscriber)s).getHandler() != handler) continue;
                this.subscribers.remove(s);
                return;
            }
            throw new IllegalArgumentException("handler:Handler is not registered.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterAll() {
        Object object = this.subscribersLock;
        synchronized (object) {
            this.subscribers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notify(T obj) {
        Object object = this.subscribersLock;
        synchronized (object) {
            int numSubs = this.subscribers.size();
            this.logger.debugFormat("Notifying {0} subscribers...", (Object)numSubs);
            for (Subscriber<T> subscriber : this.subscribers) {
                Predicate<T> filter;
                if (subscriber == null || (filter = subscriber.getFilter()) != null && !filter.invoke(obj)) continue;
                try {
                    subscriber.handle(obj);
                }
                catch (Exception e) {
                    this.logger.errorFormat("Subscriber {0} with filter {1} had exception {2}.", (Object)new Object[]{subscriber, filter, e});
                    this.onNotificationException(subscriber, e);
                }
            }
            this.logger.debugFormat("{0} subscribers notified", (Object)numSubs);
        }
    }

    protected void onNotificationException(Subscriber<T> subscriber, Exception e) {
        throw new RuntimeException("Rethrowing notification exception", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void switchSubscribersList(List<Subscriber<T>> newList) {
        Object object = this.subscribersLock;
        synchronized (object) {
            newList.addAll(this.subscribers);
            this.subscribers.clear();
            this.subscribers = newList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegateSubscriber<T>
    implements Subscriber<T> {
        private final Action<T> handler;
        private final Predicate<T> filter;

        public DelegateSubscriber(Action<T> theHandler, Predicate<T> theFilter) {
            this.handler = theHandler;
            this.filter = theFilter;
        }

        public Action<T> getHandler() {
            return this.handler;
        }

        @Override
        public Predicate<T> getFilter() {
            return this.filter;
        }

        @Override
        public void handle(T obj) {
            this.handler.handle(obj);
        }
    }
}

