/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ClientChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.IntReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolDescription;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.protocol.RegistrationException;
import com.genesyslab.platform.management.protocol.SolutionControlServerProtocolHandshakeOptions;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.ControlObjectType;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.events.EventError;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.runtime.SolutionControlServerInternalProtocolFactory;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.runtime.channel.EventClientRegistered;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.runtime.channel.RequestRegisterClient;

@ProtocolDescription.Tag(sdkName="Management", protocolName="SolutionControlServer")
public final class SolutionControlServerProtocol
extends ClientChannel
implements SolutionControlServerProtocolHandshakeOptions {
    private static final int connectCode = 1234567;
    private String clientName = null;
    private ControlObjectType clientType = ControlObjectType.Application;
    private int clientId = 0;
    private String userName = null;

    public SolutionControlServerProtocol(Endpoint endpoint) {
        super(endpoint, (ProtocolFactory)new SolutionControlServerInternalProtocolFactory(), (ReferenceBuilder)new IntReferenceBuilder());
    }

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int value) {
        this.clientId = value;
    }

    public ControlObjectType getControlObjectType() {
        return this.clientType;
    }

    public void setControlObjectType(ControlObjectType value) {
        this.clientType = value;
    }

    public int getConnectCode() {
        return 1234567;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String value) {
        this.userName = value;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String value) {
        this.clientName = value;
    }

    public ControlObjectType getClientType() {
        return this.clientType;
    }

    public void setClientType(ControlObjectType value) {
        this.clientType = value;
    }

    protected void onOpen() throws ProtocolException {
        this.setRegistrationHandler((ClientChannel.RegistrationHandler)new SCSRegistrationHandler());
        super.onOpen();
    }

    private class SCSRegistrationHandler
    extends ClientChannel.SimpleRegistrationHandler {
        private SCSRegistrationHandler() {
            super((ClientChannel)SolutionControlServerProtocol.this);
        }

        protected boolean isResponseAccepted(Message responce) throws RegistrationException {
            ILogger log = Log.getLogger(SolutionControlServerProtocol.class);
            if (responce != null && responce instanceof EventClientRegistered) {
                log.info((Object)("!!!! Successful registration: " + responce));
                return true;
            }
            if (responce instanceof EventError) {
                throw new RegistrationException("Error registering. Code: " + (Object)((Object)((EventError)responce).getErrorCode()) + ";" + (Object)((Object)((EventError)responce).getErrorCode()), responce);
            }
            if (log.isWarn()) {
                log.warn((Object)("Unexpected message registering client: " + responce));
            }
            return false;
        }

        public Message getRegistrationMessage() {
            return RequestRegisterClient.create(SolutionControlServerProtocol.this.getClientId(), SolutionControlServerProtocol.this.getConnectCode(), SolutionControlServerProtocol.this.getClientType(), SolutionControlServerProtocol.this.getUserName(), SolutionControlServerProtocol.this.getClientName());
        }
    }
}

