/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.impl.mux.UdpConnectionImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.ChannelState;
import com.genesyslab.platform.commons.protocol.ClientChannel;
import com.genesyslab.platform.commons.protocol.Endpoint;
import com.genesyslab.platform.commons.protocol.IgnoringMessageReceiverSupport;
import com.genesyslab.platform.commons.protocol.IntReferenceBuilder;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.MessageReceiverSupport;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.ReferenceBuilder;
import com.genesyslab.platform.commons.timer.Scheduler;
import com.genesyslab.platform.commons.timer.TimerAction;
import com.genesyslab.platform.commons.timer.TimerActionTicket;
import com.genesyslab.platform.commons.timer.TimerFactory;
import com.genesyslab.platform.management.protocol.LocalControlAgentProtocol;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.LcaUdpHeartbeatInternalProtocolTransportImpl;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.LocalControlAgentHeartbeatInternalProtocolFactory;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.ThreadInfoList;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.ThreadsHeartbeatsCollector;
import com.genesyslab.platform.management.protocol.localcontrolagentheartbeat.runtime.channel.RequestHeartbeatData;

public class LcaUdpHeartbeatInternalProtocol
extends ClientChannel {
    private final LocalControlAgentProtocol mainProtocol;
    private int heartbeatPeriod = 0;
    private int heartbeatTimeout = 0;
    private ThreadsHeartbeatsCollector heartbeatsCollector = null;
    private final LcaUdpHeartbeatInternalProtocolTransportImpl transport = new LcaUdpHeartbeatInternalProtocolTransportImpl();
    private Scheduler scheduler = TimerFactory.getTimer();
    private TimerAction heartbeatSendAction = new HeartbeatTimerAction();
    private TimerActionTicket heartbeatSendTask = null;
    private final Object heartbeatLifecycle = new Object();
    static final int THREAD_PER_HEARTBEAT_MESSAGE = 64;
    private static final ILogger log = Log.getLogger(LcaUdpHeartbeatInternalProtocol.class);

    public LcaUdpHeartbeatInternalProtocol(LocalControlAgentProtocol parentProtocol) {
        super(new Endpoint(parentProtocol.getEndpoint().getName() + "-udp", parentProtocol.getEndpoint().getHost(), parentProtocol.getEndpoint().getPort()), (ProtocolFactory)new LocalControlAgentHeartbeatInternalProtocolFactory(), (ReferenceBuilder)new IntReferenceBuilder());
        this.setReceiver((MessageReceiverSupport)new IgnoringMessageReceiverSupport());
        this.mainProtocol = parentProtocol;
    }

    protected void onClose(ConnectionClosedEvent event) {
        this.stopHeartbeatSender();
        super.onClose(event);
    }

    protected Connection createConnection(Endpoint endpoint) {
        UdpConnectionImpl connImpl = new UdpConnectionImpl();
        connImpl.setUri(endpoint.getHost(), endpoint.getPort());
        Connection conn = connImpl.getConnection();
        conn.setMessageTransport((MessageTransport)this.transport);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startHeartbeatSender() {
        Object object = this.heartbeatLifecycle;
        synchronized (object) {
            if (this.getState() == ChannelState.Closed) {
                try {
                    this.open();
                }
                catch (Exception e) {
                    log.error((Object)"Exception while opening heartbeat channel", (Throwable)e);
                }
            }
            this.scheduleNextHeartbeatSend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopHeartbeatSender() {
        Object object = this.heartbeatLifecycle;
        synchronized (object) {
            if (this.heartbeatSendTask != null) {
                this.heartbeatSendTask.cancel();
                this.heartbeatSendTask = null;
            }
            this.heartbeatsCollector = null;
            if (this.getState() == ChannelState.Opened) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    log.debug((Object)"Exception closing UDP Heartbeat channel", (Throwable)e);
                }
            }
        }
    }

    public void heartbeatUpdateParameters(int appPID, int period, String host, int port) {
        boolean needStop = false;
        boolean needUpdate = false;
        boolean needStart = false;
        if (this.heartbeatPeriod == 0) {
            if (period != 0) {
                log.info((Object)"Heartbeat sending thread will be started");
                needStart = true;
            }
        } else if (period == 0) {
            log.info((Object)"Heartbeat sending thread will be stopped");
            needStop = true;
        } else if (this.getEndpoint().getPort() != port) {
            log.info((Object)"Heartbeat sending thread will be re-started due to port change");
            needStop = true;
            needStart = true;
        } else {
            needUpdate = true;
        }
        if (needStop) {
            this.updateHeartbeatPeriod(0);
            if (this.getState() == ChannelState.Opened) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    log.warn((Object)"Exception closing udp heartbeat connection", (Throwable)e);
                }
            }
        }
        if (needStart) {
            this.setEndpoint(new Endpoint(this.getEndpoint().getName(), host, port));
            this.updateHeartbeatPeriod(period);
            this.startHeartbeatSender();
        }
        if (needUpdate) {
            this.updateHeartbeatPeriod(period);
        }
    }

    public void updateHeartbeatPeriod(int period) {
        this.heartbeatPeriod = period;
        this.heartbeatTimeout = (period > 3 ? period / 3 : 1) * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextHeartbeatSend() {
        Object object = this.heartbeatLifecycle;
        synchronized (object) {
            if (this.heartbeatSendTask != null) {
                this.heartbeatSendTask.cancel();
                this.heartbeatSendTask = null;
            }
            if (this.heartbeatPeriod > 0) {
                if (this.heartbeatsCollector == null) {
                    this.heartbeatsCollector = new ThreadsHeartbeatsCollector(false);
                }
                this.heartbeatSendTask = this.scheduler.schedule((long)this.heartbeatTimeout, this.heartbeatSendAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSendHeartbeats() throws ProtocolException, IllegalStateException {
        ThreadInfoList table = null;
        Object object = this.heartbeatLifecycle;
        synchronized (object) {
            this.heartbeatSendTask = null;
            if (this.heartbeatsCollector != null) {
                table = this.heartbeatsCollector.updateThreadInfoList();
            }
        }
        if (table != null) {
            while (table.size() > 64) {
                ThreadInfoList tablePart = new ThreadInfoList();
                for (int i = 0; i < 64; ++i) {
                    tablePart.add(table.remove(table.size() - 1));
                }
                this.send(this.createHeartbeatUpdateMessage(tablePart));
            }
            if (table.size() > 0) {
                this.send(this.createHeartbeatUpdateMessage(table));
            }
        }
    }

    protected Message createHeartbeatUpdateMessage(ThreadInfoList threadsInfo) {
        RequestHeartbeatData message = RequestHeartbeatData.create();
        message.setApplicationPid(this.mainProtocol.getProcessId());
        message.setApplicationDbid(0);
        message.setSessionDbid(0);
        message.setThreadInfos(threadsInfo);
        return message;
    }

    private class HeartbeatTimerAction
    implements TimerAction {
        private HeartbeatTimerAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimer() {
            try {
                LcaUdpHeartbeatInternalProtocol.this.doSendHeartbeats();
            }
            catch (Exception e) {
                log.error((Object)"Exception while sending threads heartbeats", (Throwable)e);
            }
            finally {
                if (LcaUdpHeartbeatInternalProtocol.this.getState() == ChannelState.Opened) {
                    LcaUdpHeartbeatInternalProtocol.this.scheduleNextHeartbeatSend();
                }
            }
        }
    }
}

