/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.messageserver.runtime;

import com.genesyslab.platform.commons.connection.MessagePackager;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.CommonMessageProducerImpl;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.ProtocolException;
import com.genesyslab.platform.commons.protocol.ProtocolFactory;
import com.genesyslab.platform.commons.protocol.runtime.ProtocolMessagePackagerImpl;
import com.genesyslab.platform.management.protocol.messageserver.runtime.MessageProtocolInnerPackagerImpl;

public class MessageProtocolInnerMessageParser {
    private ProtocolFactory factory;
    private MessageProtocolInnerPackagerImpl innerPackager;
    private MessageHandler messageHandler = new MessageHandler();
    private ErrorHandler errorHandler;
    private String stringAttributesEncoding;

    public MessageProtocolInnerMessageParser(ProtocolFactory protocolFactory) {
        this(protocolFactory, null);
    }

    public MessageProtocolInnerMessageParser(ProtocolFactory protocolFactory, ConnectionConfiguration config) {
        this.factory = protocolFactory;
        String encoding = null;
        if (config != null) {
            encoding = config.getOption("string-attributes-encoding");
        }
        this.stringAttributesEncoding = encoding != null && !encoding.equals("") ? encoding : EncodingSupport.DEFAULT_ENCODING;
        this.innerPackager = new MessageProtocolInnerPackagerImpl(this.factory, config, this.messageHandler, new DelegatingErrorHandler());
    }

    public Message parse(byte[] bytes, int pos, int len) throws ProtocolException {
        CommonMessageProducerImpl producer = new CommonMessageProducerImpl(bytes, pos, (MessagePackager)this.innerPackager, this.stringAttributesEncoding);
        try {
            producer.parse();
        }
        catch (InvalidPacketException e) {
            throw new ProtocolException("Can't parse message", (Throwable)e);
        }
        return this.messageHandler.message();
    }

    public Message parse(byte[] bytes) throws ProtocolException {
        return this.parse(bytes, 0, bytes.length);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private class MessageHandler
    implements ProtocolMessagePackagerImpl.MessageHandler {
        private Message message;

        private MessageHandler() {
        }

        public void onMessage(Message message) {
            this.message = message;
        }

        public Message message() {
            return this.message;
        }
    }

    private class DelegatingErrorHandler
    implements ProtocolMessagePackagerImpl.ErrorHandler {
        private DelegatingErrorHandler() {
        }

        public void handleError(ProtocolException e) {
            if (MessageProtocolInnerMessageParser.this.errorHandler != null) {
                MessageProtocolInnerMessageParser.this.errorHandler.handleError(e);
            }
        }
    }

    public static interface ErrorHandler {
        public void handleError(ProtocolException var1);
    }
}

