/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.messageserver.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.DataSupport;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.CustomPackager;
import com.genesyslab.platform.management.protocol.messageserver.AttributeList;
import com.genesyslab.platform.management.protocol.messageserver.LogDataFormat;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeListCodec
implements CustomPackager,
EncodingSupport {
    private static final String DataFormatAttribute = "inner.17";
    private static final String DataLengthAttribute = "inner.10";
    private static final String DataAttribute = "inner.12";
    private static final String ListAttribute = "Attributes";
    private static final String EntryDataAttribute = "EntryData";
    private static final String EntryDataFormatAttribute = "EntryDataFormat";
    private String strAttrEncoding = DEFAULT_ENCODING;
    private Message message = null;

    public String getNS() {
        return null;
    }

    public void setStringAttributesEncoding(String stringAttributesEncoding) {
        this.strAttrEncoding = stringAttributesEncoding != null ? stringAttributesEncoding : DEFAULT_ENCODING;
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription ai) throws CodecException {
        Element elem = CodecUtil.asElement((Source)attributeElement);
        if (elem.getNodeName().equals(ListAttribute)) {
            AttributeList attributes = new AttributeList();
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                String key = child.getAttributes().getNamedItem("key").getNodeValue();
                String value = child.getTextContent();
                if (key == null) continue;
                attributes.put(key, value);
            }
            return attributes;
        }
        return null;
    }

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        if (customTypeObject instanceof AttributeList) {
            byte[] data;
            try {
                data = this.packAttributes((AttributeList)customTypeObject);
            }
            catch (UnsupportedEncodingException e) {
                throw new CodecException("Internal exception", (Throwable)e);
            }
            transport.onAttribute(transportState, DataFormatAttribute, LogDataFormat.LogAttributes.ordinal());
            transport.onAttribute(transportState, DataLengthAttribute, data.length);
            transport.onAttribute(transportState, DataAttribute, data);
        }
        return transportState;
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        if (customTypeObject instanceof AttributeList) {
            Document doc;
            Element node;
            if (attributeElement instanceof DOMResult) {
                node = (Element)((DOMResult)attributeElement).getNode();
                doc = node.getOwnerDocument();
            } else {
                doc = CodecUtil.createDocument();
                node = doc.getDocumentElement();
            }
            for (Map.Entry entry : ((AttributeList)customTypeObject).entrySet()) {
                Element child = doc.createElementNS(node.getNamespaceURI(), "KeyValue");
                child.setAttribute("key", (String)entry.getKey());
                child.setTextContent((String)entry.getValue());
                node.appendChild(child);
            }
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void setProtocolData(Object protocolData) {
    }

    public void onMessageStart(Message message) {
        this.message = message;
    }

    public void onAttribute(String id, Object value) throws CodecException {
    }

    public void onMessageEnd() throws CodecException {
        byte[] entryData;
        Object ed;
        Object edf;
        if (this.message != null && (edf = this.message.getMessageAttribute(EntryDataFormatAttribute)) == LogDataFormat.LogAttributes && (ed = this.message.getMessageAttribute(EntryDataAttribute)) instanceof byte[] && (entryData = (byte[])ed).length > 3) {
            try {
                int pos = 4;
                int attrNum = (entryData[2] << 8) + entryData[3];
                AttributeList al = new AttributeList();
                for (int i = 0; i < attrNum; ++i) {
                    String attrVal;
                    int attrValLen;
                    int len;
                    String attrName;
                    int attrNameLen;
                    if ((attrNameLen = (attrName = new String(entryData, ++pos + 2, len = (entryData[pos] << 8) + entryData[pos + 1], this.strAttrEncoding)).length()) > 0 && attrName.charAt(attrNameLen - 1) == '\u0000') {
                        attrName = attrName.substring(0, attrNameLen - 1);
                    }
                    if ((attrValLen = (attrVal = new String(entryData, (pos += 2 + len) + 2, len = (entryData[pos] << 8) + entryData[pos + 1], this.strAttrEncoding)).length()) > 0 && attrVal.charAt(attrValLen - 1) == '\u0000') {
                        attrVal = attrVal.substring(0, attrValLen - 1);
                    }
                    al.put(attrName, attrVal);
                    pos += 2 + len;
                }
                ((DataSupport)this.message).attributes().put(ListAttribute, al);
                ((DataSupport)this.message).attributes().remove(EntryDataAttribute);
            }
            catch (UnsupportedEncodingException e) {
                throw new CodecException("Exception unpacking log attributes", (Throwable)e);
            }
        }
    }

    byte[] packAttributes(AttributeList al) throws UnsupportedEncodingException {
        int lstSize = 4;
        int zeroSize = "\u0000".getBytes(this.strAttrEncoding).length;
        for (Map.Entry me : al.entrySet()) {
            lstSize += 5 + ((String)me.getKey()).getBytes(this.strAttrEncoding).length + ((String)me.getValue()).getBytes(this.strAttrEncoding).length + 2 * zeroSize;
        }
        byte[] buff = new byte[lstSize];
        buff[0] = (byte)(lstSize >> 8 & 0xFF);
        buff[1] = (byte)(lstSize & 0xFF);
        buff[2] = (byte)(al.size() >> 8 & 0xFF);
        buff[3] = (byte)(al.size() & 0xFF);
        int offset = 4;
        for (Map.Entry me : al.entrySet()) {
            String strKey = (String)me.getKey();
            String strVal = (String)me.getValue();
            if (strKey == null || strKey.length() == 0) {
                strKey = "\u0000";
            } else if (strKey.charAt(strKey.length() - 1) != '\u0000') {
                strKey = strKey + '\u0000';
            }
            if (strVal == null || strVal.length() == 0) {
                strVal = "\u0000";
            } else if (strVal.charAt(strVal.length() - 1) != '\u0000') {
                strVal = strVal + '\u0000';
            }
            byte[] binKey = strKey.getBytes(this.strAttrEncoding);
            byte[] binVal = strVal.getBytes(this.strAttrEncoding);
            buff[offset] = 0;
            buff[offset + 1] = (byte)(binKey.length >> 8 & 0xFF);
            buff[offset + 2] = (byte)(binKey.length & 0xFF);
            System.arraycopy(binKey, 0, buff, offset + 3, binKey.length);
            buff[offset += 3 + binKey.length] = (byte)(binVal.length >> 8 & 0xFF);
            buff[offset + 1] = (byte)(binVal.length & 0xFF);
            System.arraycopy(binVal, 0, buff, offset + 2, binVal.length);
            offset += 2 + binVal.length;
        }
        return buff;
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) {
        if (customTypeObject instanceof AttributeList) {
            ((AttributeList)customTypeObject).toString(buf, 0, truncate, hide);
        }
    }

    public String getLogType() {
        return "AttrList";
    }
}

