/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.management.protocol.solutioncontrolserver;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.management.protocol.solutioncontrolserver.AlarmCause;
import java.util.Hashtable;
import java.util.Map;

public class AlarmDescription {
    private Hashtable attributes = new Hashtable();
    private static final String ATTRIBUTE_APPLICATION_DBID = "APP_DBID";
    private static final String ATTRIBUTE_ALARM_CONDITION_DBID = "AC_DBID";
    private static final String ATTRIBUTE_ALARM_ID = "ID";
    private static final String ATTRIBUTE_REASON = "RSN";
    private static final String ATTRIBUTE_LOG_MESSAGE_ID = "LM_ID";
    private static final String ATTRIBUTE_LOG_MESSAGE_TEXT = "LM_TEXT";
    private static final String ATTRIBUTE_USER_NAME = "USER";
    private static final String ATTRIBUTE_THRESHOLD_ADDITIONAL_INFO = "TRH_ADDINFO";
    private static final String ATTRIBUTE_THRESHOLD_ID = "THRSCRIPT_ID";
    private static final String ATTRIBUTE_CLEAR_REASON = "CLEARRSN";
    private static final Integer ZERO = new Integer(0);

    public AlarmDescription() {
        this.attributes.put(ATTRIBUTE_APPLICATION_DBID, ZERO);
        this.attributes.put(ATTRIBUTE_ALARM_CONDITION_DBID, ZERO);
        this.attributes.put(ATTRIBUTE_ALARM_ID, "");
        this.attributes.put(ATTRIBUTE_REASON, "");
        this.attributes.put(ATTRIBUTE_USER_NAME, "");
        this.attributes.put(ATTRIBUTE_THRESHOLD_ADDITIONAL_INFO, "");
        this.attributes.put(ATTRIBUTE_THRESHOLD_ID, ZERO);
        this.attributes.put(ATTRIBUTE_CLEAR_REASON, "");
        this.attributes.put(ATTRIBUTE_LOG_MESSAGE_ID, ZERO);
        this.attributes.put(ATTRIBUTE_LOG_MESSAGE_TEXT, "");
    }

    public AlarmDescription(int applicationId, int alarmConditionDbId, String alarmId, String reason, String userName, String thresholdAdditionalInfo, int thresholdId, String clearReason, int logMessageId, String logMessageText) {
        this.attributes.put(ATTRIBUTE_APPLICATION_DBID, new Integer(applicationId));
        this.attributes.put(ATTRIBUTE_ALARM_CONDITION_DBID, new Integer(alarmConditionDbId));
        this.attributes.put(ATTRIBUTE_ALARM_ID, alarmId);
        this.attributes.put(ATTRIBUTE_REASON, reason);
        this.attributes.put(ATTRIBUTE_USER_NAME, userName);
        this.attributes.put(ATTRIBUTE_THRESHOLD_ADDITIONAL_INFO, thresholdAdditionalInfo);
        this.attributes.put(ATTRIBUTE_THRESHOLD_ID, new Integer(thresholdId));
        this.attributes.put(ATTRIBUTE_CLEAR_REASON, clearReason);
        this.attributes.put(ATTRIBUTE_LOG_MESSAGE_ID, new Integer(logMessageId));
        this.attributes.put(ATTRIBUTE_LOG_MESSAGE_TEXT, logMessageText);
    }

    public Object get(String name) {
        return this.attributes.get(name);
    }

    public void set(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Integer getApplicationId() {
        return (Integer)this.attributes.get(ATTRIBUTE_APPLICATION_DBID);
    }

    public Integer getAlarmConditionId() {
        return (Integer)this.attributes.get(ATTRIBUTE_ALARM_CONDITION_DBID);
    }

    public AlarmCause getCause() {
        String reason = (String)this.attributes.get(ATTRIBUTE_REASON);
        if ("".equals(reason)) {
            reason = (String)this.attributes.get(ATTRIBUTE_CLEAR_REASON);
        }
        if ("".equals(reason)) {
            return AlarmCause.LogMessage;
        }
        return (AlarmCause)GEnum.getValue(AlarmCause.class, (String)reason);
    }

    public Integer getLogMessageId() {
        return (Integer)this.attributes.get(ATTRIBUTE_LOG_MESSAGE_ID);
    }

    public String getLogMessageText() {
        return (String)this.attributes.get(ATTRIBUTE_LOG_MESSAGE_TEXT);
    }

    public String getUserName() {
        return (String)this.attributes.get(ATTRIBUTE_USER_NAME);
    }

    public Integer ThresholdScriptId() {
        return (Integer)this.attributes.get(ATTRIBUTE_THRESHOLD_ID);
    }

    public int hashCode() {
        int hash = AlarmDescription.class.hashCode();
        for (Object key : this.attributes.keySet()) {
            hash ^= key.hashCode();
            hash ^= this.attributes.get(key).hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this.attributes.size() != ((AlarmDescription)obj).attributes.size()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }
}

