/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionClosedEvent;
import com.genesyslab.platform.commons.connection.ConnectionHandler;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.configuration.ConnectionContext;
import com.genesyslab.platform.commons.connection.configuration.ManagedConfiguration;
import com.genesyslab.platform.commons.connection.impl.Command;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.connection.interceptor.Interceptor;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class AbstractConnection
implements Connection {
    private static final ILogger log = Log.getLogger(AbstractConnection.class);
    private static int counter = 0;
    private int cnt;
    private String uri;
    protected String host;
    protected int port;
    protected volatile ConnectionHandler connHandler;
    private volatile ConnectionState state = ConnectionState.CLOSED;
    private boolean closing = false;
    private boolean forceClosing = false;
    private final Object closeSync = new Object();
    private Thread closingThread = null;
    private ConnectionContext ctx;
    protected SocketAddress address;
    private String stringAttributesEncoding = EncodingSupport.DEFAULT_ENCODING;
    private ManagedConfiguration configWithHandlers;
    protected final Object _syncConfig = new Object();
    private final ManagedConfiguration.Handler onChangedEncodingProperty = new ManagedConfiguration.Handler(){

        public void onPropertyChanged(Object sender, ManagedConfiguration.ChangeEvent event) {
            String encodingNew = event.getNewValue();
            if (encodingNew != null && encodingNew.length() > 0) {
                AbstractConnection.this.setStringAttributesEncoding(encodingNew);
            }
        }
    };
    private final ManagedConfiguration.Handler onChangedAddpProperty = new ManagedConfiguration.Handler(){

        public void onPropertyChanged(Object sender, ManagedConfiguration.ChangeEvent event) {
            if (event == null) {
                return;
            }
            Interceptor interceptor = AbstractConnection.this.getInterceptor();
            if (interceptor != null) {
                interceptor.configure(AbstractConnection.this.configWithHandlers);
            }
        }
    };

    protected AbstractConnection() {
        this.cnt = counter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Object object = this.closeSync;
        synchronized (object) {
            this.closing = false;
            this.forceClosing = false;
        }
        this.closingThread = null;
    }

    public Connection getConnection() {
        return this;
    }

    public void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connHandler = connectionHandler;
    }

    public ConnectionContext context() {
        return this.ctx;
    }

    public void setContext(ConnectionContext ctx) {
        this.ctx = ctx;
    }

    protected void notifyEstablishedHandler() {
        ConnectionHandler handler = this.connHandler;
        if (handler == null) {
            log.debug((Object)"ConnHandler is null, nobody to notify about established connection");
            return;
        }
        try {
            handler.onConnectionEstablished();
        }
        catch (Exception e) {
            log.warn((Object)"Exception in ConnectionHandler", (Throwable)e);
        }
    }

    protected void notifyCloseHandler(Throwable cause) {
        ConnectionHandler handler = this.connHandler;
        if (handler == null) {
            log.debug((Object)"ConnHandler is null, nobody to notify about closed connection");
            return;
        }
        ConnectionClosedEvent event = new ConnectionClosedEvent(this, cause);
        try {
            handler.onConnectionClosed(event);
        }
        catch (Exception e) {
            log.warn((Object)"Exception in ConnectionHandler", (Throwable)e);
        }
    }

    protected synchronized void setConnectionState(ConnectionState state) {
        if (state == ConnectionState.CLOSED) {
            this.unregisterConfigurationHandlers();
        }
        ConnectionState oldState = this.state;
        this.state = state;
        if (log.isDebug()) {
            log.debug((Object)("ConnState transition. '" + oldState.toString() + "' -> '" + state.toString() + "' for '" + this));
        }
    }

    public synchronized ConnectionState getConnectionState() {
        return this.state;
    }

    public String getStringAttributesEncoding() {
        return this.stringAttributesEncoding;
    }

    public void setStringAttributesEncoding(String value) {
        this.stringAttributesEncoding = value == null || value.equals("") ? EncodingSupport.DEFAULT_ENCODING : value;
    }

    public void setUri(String host, int port) {
        this.host = host;
        this.port = port;
        this.address = new InetSocketAddress(host, port);
    }

    public void setUri(InetAddress address, int port) {
        this.host = address.getHostName();
        this.port = port;
        this.address = new InetSocketAddress(address, port);
    }

    public String getUri() {
        if (this.uri == null && this.host != null) {
            this.uri = "tcp://" + this.host + ':' + this.port;
        }
        return this.uri;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        String loc = this.getUri();
        if (loc != null) {
            return loc + '[' + this.state.toString() + "]/" + this.cnt;
        }
        return "unknown[" + this.state.toString() + "]/" + this.cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable e) {
        Object object = this.closeSync;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            this.closing = true;
        }
        this.closingThread = Thread.currentThread();
        this.setConnectionState(ConnectionState.CLOSING);
        if (e != null) {
            log.debug((Object)"Emergency connection close", e);
        } else {
            log.debug((Object)"Closing connection");
        }
        this.startClose(e);
    }

    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceClose(Throwable reason) {
        Object object = this.closeSync;
        synchronized (object) {
            if (this.forceClosing) {
                return;
            }
            this.closing = true;
            this.forceClosing = true;
        }
        if (this.getConnectionState() == ConnectionState.CLOSED) {
            return;
        }
        if (this.closingThread != null) {
            this.closingThread.interrupt();
        }
        log.debugFormat("Forcing connection close. Connection: {0}", (Object)this);
        this.doClose(reason);
    }

    public void forceClose() {
        this.forceClose(null);
    }

    protected abstract void startClose(Throwable var1);

    protected void doClose(Throwable closeReason) {
        this.closingThread = null;
        this.setConnectionState(ConnectionState.CLOSED);
        this.notifyCloseHandler(closeReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterConfigurationHandlers() {
        Object object = this._syncConfig;
        synchronized (object) {
            ManagedConfiguration config = this.configWithHandlers;
            if (config == null) {
                return;
            }
            config.removeAfterPropertyChangeHandler("string-attributes-encoding", this.onChangedEncodingProperty);
            config.removeAfterPropertyChangeHandler("protocol", this.onChangedAddpProperty);
            config.removeAfterPropertyChangeHandler("x-addp-active", this.onChangedAddpProperty);
            config.removeAfterPropertyChangeHandler("addp-remote-timeout", this.onChangedAddpProperty);
            config.removeAfterPropertyChangeHandler("addp-trace", this.onChangedAddpProperty);
            config.removeAfterPropertyChangeHandler("addp-timeout", this.onChangedAddpProperty);
            this.configWithHandlers = null;
            if (log.isDebug()) {
                log.debug((Object)"Removed Attribute's handlers from connection configuration");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerConfigurationHandlers(ConnectionConfiguration config) {
        Object object = this._syncConfig;
        synchronized (object) {
            this.unregisterConfigurationHandlers();
            if (config == null) {
                return;
            }
            if (config instanceof ManagedConfiguration) {
                if (log.isDebug()) {
                    log.debug((Object)"Assigned Attribute's handlers for connection configuration");
                }
                ManagedConfiguration mcfg = (ManagedConfiguration)config;
                mcfg.addAfterPropertyChangeHandler("string-attributes-encoding", this.onChangedEncodingProperty);
                mcfg.addAfterPropertyChangeHandler("protocol", this.onChangedAddpProperty);
                mcfg.addAfterPropertyChangeHandler("x-addp-active", this.onChangedAddpProperty);
                mcfg.addAfterPropertyChangeHandler("addp-remote-timeout", this.onChangedAddpProperty);
                mcfg.addAfterPropertyChangeHandler("addp-trace", this.onChangedAddpProperty);
                mcfg.addAfterPropertyChangeHandler("addp-timeout", this.onChangedAddpProperty);
                this.configWithHandlers = mcfg;
            }
        }
    }

    public class CloseCommand
    implements Command {
        private Throwable reason;

        public CloseCommand(Throwable reason) {
            this.reason = reason;
        }

        public Object execute() {
            log.debug((Object)"Executing close command");
            AbstractConnection.this.doClose(this.reason);
            return null;
        }
    }
}

