/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.mux;

import com.genesyslab.platform.commons.connection.ConnectionAcceptor;
import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.impl.AbstractAcceptorImpl;
import com.genesyslab.platform.commons.connection.impl.mux.MultiplexingConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.mux.SelectorManager;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class MultiplexingAcceptor
extends AbstractAcceptorImpl
implements ConnectionAcceptor {
    private static final ILogger log = Log.getLogger(MultiplexingAcceptor.class);
    private ServerSocketChannel channel = null;

    protected MultiplexingAcceptor() {
    }

    public void startAccepting() throws IOException {
        log.debug((Object)"Binding...");
        if (this.channel != null) {
            throw new PsdkConnectionException("Acceptor is already opened");
        }
        if (this.address == null) {
            throw new PsdkConnectionException("Acceptor is not initialized, address is missing");
        }
        this.channel = ServerSocketChannel.open();
        this.channel.configureBlocking(false);
        SelectorManager.registerServerChannel(this.channel, this);
        SelectorManager.getSelector().wakeup();
        this.channel.socket().bind(this.address);
        log.debug((Object)"Socket is bound");
    }

    public void close() {
        if (this.channel != null && this.channel.isOpen()) {
            try {
                log.debug((Object)"Closing acceptor");
                this.channel.close();
                log.debug((Object)"Acceptor closed");
            }
            catch (IOException e) {
                log.warn((Object)"Failed to close server channel", (Throwable)e);
            }
            this.channel = null;
        }
    }

    public ConnectionAcceptor getAcceptor() {
        return this;
    }

    public void handleConnection(SocketChannel channel) {
        MultiplexingConnectionImpl impl = new MultiplexingConnectionImpl();
        try {
            impl.attach(channel);
            Selector selector = SelectorManager.getSelector();
            channel.register(selector, 5, impl);
        }
        catch (IOException e) {
            log.warn((Object)"Failed to attach to connection", (Throwable)e);
        }
        this.newConnectionNotification(impl);
    }
}

