/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.mux;

import com.genesyslab.platform.commons.connection.impl.AbstractConnection;
import com.genesyslab.platform.commons.connection.impl.Command;
import com.genesyslab.platform.commons.connection.impl.CommandQueue;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.WritePoint;
import com.genesyslab.platform.commons.connection.impl.mux.BufferWritePoint;
import com.genesyslab.platform.commons.connection.impl.mux.MultiplexingConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.mux.SelectorManager;
import com.genesyslab.platform.commons.connection.impl.mux.SelectorWriteDataCommandImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;

public class SelectorWritePipeImpl
implements WritePipe {
    private final ILogger log = Log.getLogger(SelectorWritePipeImpl.class);
    private final MultiplexingConnectionImpl connection;
    private final Command writeCommand = new NeedWriteCommand();

    public SelectorWritePipeImpl(MultiplexingConnectionImpl connection) {
        this.connection = connection;
    }

    public void write(WritePoint writePoint) {
        if (!(writePoint instanceof BufferWritePoint)) {
            throw new IllegalArgumentException("BufferedWritePoint supported only");
        }
        this.pushData((BufferWritePoint)writePoint);
    }

    public WritePoint createWritePoint() {
        return new BufferWritePoint();
    }

    public void close(Throwable closeReason) {
        this.log.debug((Object)"Issuing close command");
        CommandQueue dataQueue = this.connection.getDataQueue();
        MultiplexingConnectionImpl multiplexingConnectionImpl = this.connection;
        multiplexingConnectionImpl.getClass();
        dataQueue.put(multiplexingConnectionImpl.new AbstractConnection.CloseCommand(closeReason));
        this.anounceWriteInterest();
    }

    private void pushData(BufferWritePoint wp) {
        CommandQueue dataQueue = this.connection.getDataQueue();
        dataQueue.put(new SelectorWriteDataCommandImpl(wp));
        this.anounceWriteInterest();
    }

    private void anounceWriteInterest() {
        SelectorManager.getManagementQueue().put(this.writeCommand);
        SelectorManager.getSelector().wakeup();
    }

    private class NeedWriteCommand
    implements Command {
        private NeedWriteCommand() {
        }

        public Object execute() {
            try {
                SocketChannel channel = SelectorWritePipeImpl.this.connection.getChannel();
                if (channel != null) {
                    SelectorManager.addInterest(channel, 4, SelectorWritePipeImpl.this.connection);
                } else {
                    SelectorWritePipeImpl.this.log.debug((Object)"channel is null in NeedWriteCommand");
                }
            }
            catch (ClosedChannelException e) {
                SelectorWritePipeImpl.this.log.debug((Object)"Channel closed while trying to write", (Throwable)e);
                SelectorWritePipeImpl.this.connection.close(e);
            }
            return null;
        }
    }
}

