/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.netty;

import com.genesyslab.platform.commons.connection.ConnectionAcceptor;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.AbstractAcceptorImpl;
import com.genesyslab.platform.commons.connection.impl.InetAddressResolver;
import com.genesyslab.platform.commons.connection.impl.netty.NettyConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.netty.NettyUtil;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAcceptor
extends AbstractAcceptorImpl {
    private static final ILogger log = Log.getLogger(NettyAcceptor.class);
    private static final boolean DEFAULT_ENABLE_IPV6 = false;
    private static final boolean DEFAULT_REUSE_ADDRESS = true;
    private boolean ipv6Enabled;
    private ChannelFactory channelFactory;
    private Channel serverParentChannel;

    @Override
    public void startAccepting() throws IOException {
        log.debug((Object)"Binding Netty...");
        this.validateAndSetIpOptions();
        this.validateOrFixAddress();
        this.channelFactory = NettyUtil.serverChannelFactory(this.context());
        ServerBootstrap bootstrap = new ServerBootstrap(this.channelFactory);
        bootstrap.setPipeline(this.initPipeline());
        bootstrap.setOptions(this.options());
        this.serverParentChannel = bootstrap.bind();
        log.debug((Object)"Socket is bound");
    }

    private void validateAndSetIpOptions() {
        ConnectionConfiguration config = this.context().configuration();
        String ipVersion = null;
        if (null != config) {
            this.ipv6Enabled = config.getBoolean("enable-ipv6", false);
            ipVersion = config.getOption("ip-version");
        } else {
            this.ipv6Enabled = false;
        }
        if (null != ipVersion) {
            log.warn((Object)"ip-version value will be ignored: it has no meaning for server application");
            if (!this.ipv6Enabled) {
                log.warn((Object)"IPv6 is not enabled, ip-version value will be ignored");
            }
        }
    }

    private void validateOrFixAddress() throws IOException {
        InetSocketAddress socketAddress = (InetSocketAddress)this.address;
        InetAddress inetAddress = socketAddress.getAddress();
        boolean ipv6Addr = inetAddress instanceof Inet6Address;
        if (!ipv6Addr || this.ipv6Enabled) {
            return;
        }
        log.warn((Object)"IPv6 address is specified, but option enable-ipv6 is set to 0 (IPv6 is disabled)");
        boolean fixed = false;
        if (inetAddress.isAnyLocalAddress()) {
            log.warn((Object)"Specified IPv6 address is anylocal, changing it to IPv4 anylocal.");
            this.address = new InetSocketAddress("0.0.0.0", socketAddress.getPort());
            fixed = true;
        }
        if (!fixed && inetAddress.isLoopbackAddress()) {
            log.warn((Object)"Specified IPv6 address is loopback, changing it to IPv4 loopback.");
            this.address = new InetSocketAddress("127.0.0.1", socketAddress.getPort());
            fixed = true;
        }
        if (!fixed) {
            try {
                Inet4Address ipv4Address = InetAddressResolver.getInet4Address(inetAddress.getHostName());
                if (null != ipv4Address) {
                    log.warn((Object)"Resolving host name to IPv4 address.");
                    this.address = new InetSocketAddress(ipv4Address, socketAddress.getPort());
                    fixed = true;
                }
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        if (!fixed) {
            throw new IOException("IPv6 address is specified, but option enable-ipv6 is set to 0 (IPv6 is disabled)");
        }
    }

    @Override
    public void close() {
        if (null != this.serverParentChannel) {
            this.serverParentChannel.close();
        }
        NettyUtil.releaseServerChannelFactory(this.channelFactory);
    }

    private ChannelPipeline initPipeline() {
        return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new Handler()});
    }

    private Map<String, Object> options() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ConnectionConfiguration config = this.context().configuration();
        if (null != config) {
            result.put("reuseAddress", config.getBoolean("reuse-address", true));
            if (null != config.getOption("keep-alive")) {
                result.put("keepAlive", config.getBoolean("keep-alive"));
            }
        }
        result.put("localAddress", this.address);
        return result;
    }

    @Override
    public ConnectionAcceptor getAcceptor() {
        return this;
    }

    private class Handler
    extends SimpleChannelHandler {
        private Handler() {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelConnected(ctx, e);
            NettyConnectionImpl impl = NettyConnectionImpl.createServerConnection();
            impl.setContext(NettyAcceptor.this.context());
            impl.attach(e.getChannel());
            ConnectionConfiguration configuration = NettyAcceptor.this.context().configuration();
            if (configuration != null && configuration.getBoolean("tls")) {
                impl.startTLS(false);
            }
            NettyAcceptor.this.newConnectionNotification(impl);
        }
    }
}

