/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons.connection.impl.netty;

import com.genesyslab.platform.commons.connection.Connection;
import com.genesyslab.platform.commons.connection.ConnectionException;
import com.genesyslab.platform.commons.connection.ConnectionState;
import com.genesyslab.platform.commons.connection.PsdkConnectionException;
import com.genesyslab.platform.commons.connection.StartTLSSupport;
import com.genesyslab.platform.commons.connection.configuration.ConnectionConfiguration;
import com.genesyslab.platform.commons.connection.impl.AbstractConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.ConnectionImpl;
import com.genesyslab.platform.commons.connection.impl.ContextUtil;
import com.genesyslab.platform.commons.connection.impl.InetAddressResolver;
import com.genesyslab.platform.commons.connection.impl.InvalidPacketException;
import com.genesyslab.platform.commons.connection.impl.WritePipe;
import com.genesyslab.platform.commons.connection.impl.netty.NettyUtil;
import com.genesyslab.platform.commons.connection.impl.netty.NettyWritePipeImpl;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.UnresolvedAddressException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.SucceededChannelFuture;
import org.jboss.netty.handler.ssl.SslHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyConnectionImpl
extends AbstractConnectionImpl
implements Connection,
ConnectionImpl,
StartTLSSupport {
    public static final String CHANNEL_FACTORY_CTX_KEY = "com.genesyslab.platform.commons.connection.impl.netty.ChannelFactory";
    private static final boolean DEFAULT_ENABLE_IPV6 = false;
    private static final String DEFAULT_IP_VERSION = "4,6";
    private static final String SSL_HANDLER_NAME = "ssl-handler";
    private static final String INBOUND_HANDLER_NAME = "inbound-handler";
    private static final String CONNECTION_INBOUND_HANDLER_NAME = "connection-inbound-handler";
    private String ipVersion;
    private boolean ip6Enabled;
    private final ILogger log = Log.getLogger(NettyConnectionImpl.class);
    private final NettyWritePipeImpl writePipe = new NettyWritePipeImpl(this);
    private int timeout;
    private final Object channelFactoryLock = new Object();
    private ChannelFactory channelFactory;
    private ChannelFactory serverChannelFactory;
    private volatile OpenConnectionTask openConnectionTask;
    private volatile ChannelFuture connectFuture;
    private volatile Channel channel;
    private final ChannelFutureListener closeListener = new CloseListener();

    public static NettyConnectionImpl createServerConnection() {
        NettyConnectionImpl n = new NettyConnectionImpl();
        n.setServerConnection(true);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaseChannelFactory() {
        Object object = this.channelFactoryLock;
        synchronized (object) {
            if (this.channelFactory == null) {
                this.channelFactory = NettyUtil.clientChannelFactory(this.context());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaseServerChannelFactory() {
        Object object = this.channelFactoryLock;
        synchronized (object) {
            ChannelFactory oldFactory = this.serverChannelFactory;
            this.serverChannelFactory = this.channel != null ? NettyUtil.useServerChannelFactory(this.channel.getFactory()) : null;
            if (oldFactory != null) {
                NettyUtil.releaseServerChannelFactory(oldFactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseChannelFactory() {
        Object object = this.channelFactoryLock;
        synchronized (object) {
            if (this.serverChannelFactory != null) {
                NettyUtil.releaseServerChannelFactory(this.serverChannelFactory);
                this.serverChannelFactory = null;
            }
            if (this.channelFactory != null) {
                NettyUtil.releaseClientChannelFactory(this.channelFactory);
                this.channelFactory = null;
            }
        }
    }

    @Override
    public void open() {
        super.open();
        this.log.debugFormat("Opening Netty connection {0}", (Object)this);
        this.setConnectionState(ConnectionState.OPENING);
        this.timeout = this.getConfigTimeout("operation-timeout", 500);
        this.validateAndSetIpOptions();
        this.getInvoker().invoke((Runnable)new OpenConnectionTask());
    }

    private ChannelPipeline initPipeline() {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast(CONNECTION_INBOUND_HANDLER_NAME, (ChannelHandler)new ConnectionTimeInboundHandler());
        return pipeline;
    }

    private void validateAndSetIpOptions() {
        if (null != this.config) {
            this.ip6Enabled = this.config.getBoolean("enable-ipv6", false);
            this.ipVersion = this.config.getOption("ip-version");
        } else {
            this.ip6Enabled = false;
        }
        if (null == this.ipVersion) {
            this.ipVersion = DEFAULT_IP_VERSION;
        } else if (!this.ip6Enabled) {
            this.log.warn((Object)"IPv6 is not enabled, ip-version value will be ignored");
        }
    }

    private void tryOpen(ClientBootstrap bootstrap, List<? extends InetAddress> ipAddresses, int ipAddressIndex) {
        InetAddress ipAddress = ipAddresses.get(ipAddressIndex);
        this.log.debugFormat("Trying to open connection to {0}", (Object)ipAddress);
        bootstrap.setOption("remoteAddress", (Object)new InetSocketAddress(ipAddress, this.port));
        this.connectFuture = bootstrap.connect();
        this.connectFuture.addListener((ChannelFutureListener)new ConnectionListener(bootstrap, ipAddresses, ipAddressIndex));
    }

    @Override
    public WritePipe getWritePipe() {
        return this.writePipe;
    }

    @Override
    public void startTLS() throws GeneralSecurityException {
        this.startTLS(this.isClientChannel());
    }

    protected void startTLS(boolean clientMode) throws GeneralSecurityException {
        ChannelPipeline pipeline = this.channel.getPipeline();
        if (pipeline == null || this.getSSLHandler(pipeline) != null) {
            throw new PsdkConnectionException("can't start TLS");
        }
        SslHandler sslHandler = this.addSSLHandler(pipeline, clientMode);
        if (clientMode) {
            try {
                this.awaitFuture(sslHandler.handshake());
            }
            catch (InterruptedException e) {
                throw new GeneralSecurityException("TLS handshake was interrupted", e);
            }
        }
    }

    @Override
    public void stopTLS() {
        ChannelPipeline pipeline = this.channel.getPipeline();
        SslHandler sslHandler = this.getSSLHandler(pipeline);
        if (null == sslHandler) {
            throw new PsdkConnectionException("can't stop TLS");
        }
        sslHandler.close();
        this.removeSSLHandler(pipeline);
    }

    @Override
    public boolean stopReading() {
        ChannelFuture cf = this.channel.setReadable(false);
        try {
            this.awaitFuture(cf);
            boolean success = cf.isSuccess();
            Throwable cause = cf.getCause();
            if (!success && null != cause) {
                this.log.error((Object)"Could not stop reading for channel", cause);
            }
            return success;
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Could not stop reading for channel", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean resumeReading() {
        ChannelFuture cf = this.channel.setReadable(true);
        try {
            this.awaitFuture(cf);
            boolean success = cf.isSuccess();
            Throwable cause = cf.getCause();
            if (!success && null != cause) {
                this.log.error((Object)"Could not resume reading for channel", cause);
            }
            return success;
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Could not resume reading for channel", (Throwable)e);
            return false;
        }
    }

    private void awaitFuture(ChannelFuture channelFuture) throws InterruptedException {
        if (this.timeout <= 0) {
            channelFuture.await();
        } else {
            channelFuture.await((long)this.timeout);
        }
    }

    private boolean isClientChannel() {
        return null != this.channelFactory;
    }

    @Override
    protected void startClose(final Throwable closeReason) {
        this.cancelConnection();
        if (null == this.channel) {
            return;
        }
        if (null != closeReason) {
            ExceptionEvent e = new ExceptionEvent(){

                public Throwable getCause() {
                    return closeReason;
                }

                public Channel getChannel() {
                    return NettyConnectionImpl.this.channel;
                }

                public ChannelFuture getFuture() {
                    return new SucceededChannelFuture(NettyConnectionImpl.this.channel);
                }
            };
            this.channel.getPipeline().sendUpstream((ChannelEvent)e);
        } else {
            this.channel.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    private synchronized boolean isCancelledState() {
        return ConnectionState.CLOSING == this.getConnectionState() || ConnectionState.CLOSED == this.getConnectionState();
    }

    private void cancelConnection() {
        ChannelFuture future = this.connectFuture;
        if (null != future) {
            future.cancel();
        }
    }

    @Override
    protected void doClose(Throwable closeReason) {
        this.cancelConnection();
        Channel closingChannel = this.channel;
        this.channel = null;
        this.doClose(closingChannel, closeReason);
    }

    private void doClose(Channel closingChannel, Throwable closeReason) {
        if (closingChannel != null) {
            closingChannel.close();
        }
        if (this.channelFactory != null || this.serverChannelFactory != null) {
            this.releaseChannelFactory();
        }
        super.doClose(closeReason);
    }

    protected Channel getChannel() {
        return this.channel;
    }

    private void assignChannel(Channel channel) {
        this.channel = channel;
        this.removeConnectionTimeInboundHandler(channel.getPipeline());
        this.addInboundHandler(channel.getPipeline());
        this.addCloseListener(channel);
    }

    @Override
    public InetSocketAddress getRemoteEndPoint() {
        SocketAddress sa = null;
        if (this.channel != null) {
            sa = this.channel.getRemoteAddress();
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    @Override
    public InetSocketAddress getLocalEndPoint() {
        SocketAddress sa = null;
        if (this.channel != null) {
            sa = this.channel.getLocalAddress();
        }
        if (sa instanceof InetSocketAddress) {
            return (InetSocketAddress)sa;
        }
        return null;
    }

    private void handleConnectionClose(Throwable cause) {
        if (cause == null && ConnectionState.CLOSING != this.getConnectionState() && ConnectionState.CLOSED != this.getConnectionState() && this.isClientChannel()) {
            cause = new ConnectionException("Connection is closed by remote peer for " + this);
        }
        this.doClose((Throwable)cause);
    }

    private boolean isTLSEnabled() {
        ConnectionConfiguration conf = this.context().configuration();
        return null != conf && conf.getBoolean("tls");
    }

    private SslHandler createSSLHandler(boolean clientMode) {
        SSLEngine engine = ContextUtil.sslEngine(this.context(), this.host, this.port, clientMode);
        return new SslHandler(engine);
    }

    private SslHandler getSSLHandler(ChannelPipeline pipeline) {
        SslHandler result = null;
        if (null != pipeline) {
            result = (SslHandler)pipeline.get(SSL_HANDLER_NAME);
        }
        return result;
    }

    private SslHandler addSSLHandler(ChannelPipeline pipeline, boolean clientMode) {
        SslHandler handler = this.getSSLHandler(pipeline);
        if (null == handler) {
            handler = this.createSSLHandler(clientMode);
            pipeline.addFirst(SSL_HANDLER_NAME, (ChannelHandler)handler);
        }
        return handler;
    }

    private SslHandler removeSSLHandler(ChannelPipeline pipeline) {
        SslHandler handler = this.getSSLHandler(pipeline);
        if (null != handler) {
            pipeline.remove((ChannelHandler)handler);
        }
        return handler;
    }

    private InboundHandler getInboundHandler(ChannelPipeline pipeline) {
        InboundHandler result = null;
        if (null != pipeline) {
            result = (InboundHandler)pipeline.get(INBOUND_HANDLER_NAME);
        }
        return result;
    }

    private ConnectionTimeInboundHandler getConnectionTimeInboundHandler(ChannelPipeline pipeline) {
        ConnectionTimeInboundHandler result = null;
        if (null != pipeline) {
            result = (ConnectionTimeInboundHandler)pipeline.get(CONNECTION_INBOUND_HANDLER_NAME);
        }
        return result;
    }

    private InboundHandler addInboundHandler(ChannelPipeline pipeline) {
        InboundHandler handler = this.getInboundHandler(pipeline);
        if (null == handler) {
            handler = new InboundHandler();
            pipeline.addLast(INBOUND_HANDLER_NAME, (ChannelHandler)handler);
        }
        return handler;
    }

    private InboundHandler removeInboundHandler(ChannelPipeline pipeline) {
        InboundHandler handler = this.getInboundHandler(pipeline);
        if (null != handler) {
            pipeline.remove((ChannelHandler)handler);
        }
        return handler;
    }

    private ConnectionTimeInboundHandler removeConnectionTimeInboundHandler(ChannelPipeline pipeline) {
        ConnectionTimeInboundHandler handler = this.getConnectionTimeInboundHandler(pipeline);
        if (null != handler) {
            pipeline.remove((ChannelHandler)handler);
        }
        return handler;
    }

    private void addCloseListener(Channel channel) {
        channel.getCloseFuture().addListener(this.closeListener);
    }

    private void removeCloseListener(Channel channel) {
        channel.getCloseFuture().removeListener(this.closeListener);
    }

    private Map<String, Object> options() {
        int connectionTimeout;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("remoteAddress", this.address);
        InetSocketAddress localAddress = this.getConfigLocalEndpoint();
        if (null != localAddress) {
            result.put("localAddress", localAddress);
        }
        if ((connectionTimeout = this.getConfigTimeout("connection-timeout", -1)) > 0) {
            result.put("connectTimeoutMillis", connectionTimeout);
        }
        if (null != this.config) {
            if (null != this.config.getOption("reuse-address")) {
                result.put("reuseAddress", this.config.getBoolean("reuse-address"));
            }
            if (null != this.config.getOption("keep-alive")) {
                result.put("keepAlive", this.config.getBoolean("keep-alive"));
            }
        }
        return result;
    }

    public void attach(Channel channel) {
        this.setConnectionState(ConnectionState.OPENING);
        if (this.log.isDebug()) {
            this.log.debugFormat("Attaching to channel: {0} on connection ''{1}''", (Object)new Object[]{channel, this});
        }
        this.channel = channel;
        this.leaseServerChannelFactory();
        this.address = channel.getRemoteAddress();
        if (this.address instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)this.address;
            this.host = socketAddress.getHostName();
            this.port = socketAddress.getPort();
        }
        this.addInboundHandler(channel.getPipeline());
        this.addCloseListener(channel);
        this.setConnectionState(ConnectionState.OPENED);
    }

    private class CloseListener
    implements ChannelFutureListener {
        private CloseListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            NettyConnectionImpl.this.handleConnectionClose(future.getCause());
        }
    }

    private class ConnectionTimeInboundHandler
    extends SimpleChannelUpstreamHandler {
        private ConnectionTimeInboundHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            Throwable t = e.getCause();
            boolean forceClose = false;
            if (t instanceof BindException) {
                NettyConnectionImpl.this.log.error((Object)("Could not bind to local port \"" + NettyConnectionImpl.this.getConfigLocalEndpoint() + "\" on connection \"" + NettyConnectionImpl.this + "\""), t);
                forceClose = true;
            } else if (t instanceof SocketException && t.getCause() instanceof UnresolvedAddressException) {
                NettyConnectionImpl.this.log.error((Object)("Could not bind to local address \"" + NettyConnectionImpl.this.getConfigLocalEndpoint() + "\" on connection \"" + NettyConnectionImpl.this + "\""), t);
                forceClose = true;
            } else {
                NettyConnectionImpl.this.log.debug((Object)("Exception on connection \"" + NettyConnectionImpl.this + "\": "), t);
            }
            if (forceClose) {
                Channel ch = e.getChannel();
                NettyConnectionImpl.this.removeCloseListener(ch);
                NettyConnectionImpl.this.doClose(ch, e.getCause());
            }
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            Object message = e.getMessage();
            if (message instanceof ChannelBuffer) {
                ChannelBuffer buffer = (ChannelBuffer)message;
                int cnt = buffer.readableBytes();
                byte[] bytes = new byte[cnt];
                buffer.readBytes(bytes);
                String hexDump = NettyConnectionImpl.bytesToHexDump(bytes);
                NettyConnectionImpl.this.log.debug((Object)("Unexpected inbound data encountered on \"" + NettyConnectionImpl.this + "\": " + hexDump));
            } else {
                NettyConnectionImpl.this.log.debug((Object)("Unexpected message type encountered on \"" + NettyConnectionImpl.this + "\": " + message.getClass().getName()));
            }
        }
    }

    private class InboundHandler
    extends SimpleChannelUpstreamHandler {
        private InboundHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            if (NettyConnectionImpl.this.log.isDebug()) {
                NettyConnectionImpl.this.log.debug((Object)("Exception on connection \"" + NettyConnectionImpl.this + "\": "), e.getCause());
            }
            Channel ch = e.getChannel();
            NettyConnectionImpl.this.removeCloseListener(ch);
            NettyConnectionImpl.this.doClose(ch, e.getCause());
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws ConnectionException {
            Object message = e.getMessage();
            if (message instanceof ChannelBuffer) {
                ChannelBuffer buffer = (ChannelBuffer)message;
                int cnt = buffer.readableBytes();
                byte[] bytes = new byte[cnt];
                buffer.readBytes(bytes);
                try {
                    NettyConnectionImpl.this.getMessageTransport().processData(bytes, 0, cnt);
                }
                catch (InvalidPacketException ex) {
                    String hexDump = NettyConnectionImpl.bytesToHexDump(bytes);
                    NettyConnectionImpl.this.log.debug((Object)("Invalid packet encountered on \"" + NettyConnectionImpl.this + "\": " + hexDump), (Throwable)((Object)ex));
                }
            } else {
                throw new ConnectionException("Unexpected message type, simple buffer expected");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TLSHandshakeListener
    extends ConnectionListener {
        private TLSHandshakeListener(ClientBootstrap bootstrap, List<? extends InetAddress> ipAddresses, int ipAddressIndex) {
            super(bootstrap, ipAddresses, ipAddressIndex);
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            NettyConnectionImpl.this.connectFuture = null;
            if (future.isCancelled() || NettyConnectionImpl.this.isCancelledState()) {
                this.handleCancellation(future, "TLS handshake was cancelled for " + NettyConnectionImpl.this);
            } else if (future.isSuccess()) {
                NettyConnectionImpl.this.log.debug((Object)"TLS handshake succeeded");
                this.handleSuccess(future);
            } else {
                this.tryNextIP(future, "TLS handshake with remote host did not succeed, trying next IP address");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionListener
    implements ChannelFutureListener {
        protected final ClientBootstrap bootstrap;
        protected final List<? extends InetAddress> ipAddresses;
        protected final int ipAddressIndex;

        private ConnectionListener(ClientBootstrap bootstrap, List<? extends InetAddress> ipAddresses, int ipAddressIndex) {
            this.bootstrap = bootstrap;
            this.ipAddresses = ipAddresses;
            this.ipAddressIndex = ipAddressIndex;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            NettyConnectionImpl.this.connectFuture = null;
            if (future.isCancelled() || NettyConnectionImpl.this.isCancelledState()) {
                this.handleCancellation(future, "Connection was cancelled for " + NettyConnectionImpl.this);
            } else if (future.isSuccess()) {
                NettyConnectionImpl.this.log.debugFormat("Connection {0} is established", (Object)NettyConnectionImpl.this);
                if (NettyConnectionImpl.this.isTLSEnabled()) {
                    this.tryTLSHandshake(future);
                } else {
                    this.handleSuccess(future);
                }
            } else {
                this.tryNextIP(future, "Could not connect to remote host, trying next IP address for " + NettyConnectionImpl.this);
            }
        }

        protected void tryTLSHandshake(ChannelFuture future) {
            SslHandler sslHandler = NettyConnectionImpl.this.addSSLHandler(future.getChannel().getPipeline(), true);
            if (null != sslHandler) {
                NettyConnectionImpl.this.connectFuture = sslHandler.handshake();
                NettyConnectionImpl.this.connectFuture.addListener((ChannelFutureListener)new TLSHandshakeListener(this.bootstrap, this.ipAddresses, this.ipAddressIndex));
            }
        }

        protected void tryNextIP(ChannelFuture future, String message) {
            NettyConnectionImpl.this.removeSSLHandler(future.getChannel().getPipeline());
            NettyConnectionImpl.this.removeInboundHandler(future.getChannel().getPipeline());
            Throwable th = future.getCause();
            if (this.ipAddressIndex + 1 < this.ipAddresses.size()) {
                NettyConnectionImpl.this.log.debug((Object)message, th);
                NettyConnectionImpl.this.tryOpen(this.bootstrap, this.ipAddresses, this.ipAddressIndex + 1);
            } else {
                NettyConnectionImpl.this.handleConnectionClose(th);
            }
        }

        protected void handleSuccess(ChannelFuture future) {
            NettyConnectionImpl.this.assignChannel(future.getChannel());
            NettyConnectionImpl.this.writePipe.writePendingData();
            if (NettyConnectionImpl.this.isCancelledState()) {
                NettyConnectionImpl.this.doClose(null);
                return;
            }
            NettyConnectionImpl.this.setConnectionState(ConnectionState.OPENED);
            NettyConnectionImpl.this.notifyEstablishedHandler();
        }

        protected void handleCancellation(ChannelFuture future, String message) {
            NettyConnectionImpl.this.log.debug((Object)message);
            Object th = future.getCause();
            if (null == th) {
                th = new ConnectionException(message);
            }
            NettyConnectionImpl.this.doClose((Throwable)th);
        }
    }

    class OpenConnectionTask
    implements Runnable {
        OpenConnectionTask() {
        }

        private void checkInterruption() throws InterruptedException {
            if (NettyConnectionImpl.this.isCancelledState()) {
                throw new InterruptedException("Connection opening is cancelled for " + NettyConnectionImpl.this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NettyConnectionImpl.this.openConnectionTask = this;
            try {
                ClientBootstrap bootstrap;
                ArrayList<Object> ipAddresses;
                try {
                    List<Object> ip6Addresses;
                    NettyConnectionImpl.this.log.debugFormat("Getting IPv4 addresses for host \"{0}\"...", (Object)NettyConnectionImpl.this.host);
                    this.checkInterruption();
                    List<Inet4Address> ip4Addresses = InetAddressResolver.getInet4Addresses(NettyConnectionImpl.this.host);
                    NettyConnectionImpl.this.log.debugFormat("Found {0} IPv4 address(es) for host \"{1}\"", (Object)new Object[]{ip4Addresses.size(), NettyConnectionImpl.this.host});
                    this.checkInterruption();
                    if (NettyConnectionImpl.this.ip6Enabled) {
                        NettyConnectionImpl.this.log.debugFormat("Getting IPv6 addresses for host \"{0}\"...", (Object)NettyConnectionImpl.this.host);
                        ip6Addresses = InetAddressResolver.getInet6Addresses(NettyConnectionImpl.this.host);
                        NettyConnectionImpl.this.log.debugFormat("Found {0} IPv6 address(es) for host \"{1}\"", (Object)new Object[]{ip6Addresses.size(), NettyConnectionImpl.this.host});
                    } else {
                        NettyConnectionImpl.this.log.debugFormat("IPv6 is not enabled, skipping getting IPv6 addresses for host \"{0}\"...", (Object)NettyConnectionImpl.this.host);
                        ip6Addresses = Collections.emptyList();
                    }
                    if (ip4Addresses.size() == 0 && ip6Addresses.size() == 0) {
                        throw new IllegalArgumentException("Could not find any IP addresses for the remote host " + NettyConnectionImpl.this.host + " that are compliant with IPv6 connection options for " + NettyConnectionImpl.this);
                    }
                    ipAddresses = new ArrayList<Object>();
                    if (NettyConnectionImpl.DEFAULT_IP_VERSION.equals(NettyConnectionImpl.this.ipVersion)) {
                        ipAddresses.addAll(ip4Addresses);
                        ipAddresses.addAll(ip6Addresses);
                    } else {
                        ipAddresses.addAll(ip6Addresses);
                        ipAddresses.addAll(ip4Addresses);
                    }
                    this.checkInterruption();
                    NettyConnectionImpl.this.leaseChannelFactory();
                    bootstrap = new ClientBootstrap(NettyConnectionImpl.this.channelFactory);
                    bootstrap.setPipeline(NettyConnectionImpl.this.initPipeline());
                    bootstrap.setOptions(NettyConnectionImpl.this.options());
                    this.checkInterruption();
                }
                catch (Exception e) {
                    NettyConnectionImpl.super.doClose(e);
                    if (NettyConnectionImpl.this.channelFactory != null || NettyConnectionImpl.this.serverChannelFactory != null) {
                        NettyConnectionImpl.this.releaseChannelFactory();
                    }
                    NettyConnectionImpl.this.openConnectionTask = null;
                    return;
                }
                try {
                    NettyConnectionImpl.this.tryOpen(bootstrap, ipAddresses, 0);
                }
                catch (Exception e) {
                    NettyConnectionImpl.this.doClose(e);
                }
            }
            finally {
                NettyConnectionImpl.this.openConnectionTask = null;
            }
        }
    }
}

