/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.obj;

import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectAttributeException;
import com.genesyslab.platform.configuration.protocol.obj.ConfObjectBase;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfDataCollection<T>
extends ArrayList<T> {
    private final CfgDescriptionAttributeReference attrInfo;
    private final CfgDescriptionClass classInfo;

    protected ConfDataCollection(CfgDescription metadata) {
        this(metadata, 4);
    }

    protected ConfDataCollection(CfgDescription metadata, int initSize) {
        if (metadata == null) {
            throw new ConfObjectAttributeException("ConfDataCollection.metadata");
        }
        if (!metadata.isCfgType(CfgTypeMask.Object) && !metadata.isCfgType(CfgTypeMask.List)) {
            throw new ConfObjectAttributeException("Wrong class or attribute type for ConfDataCollection");
        }
        if (metadata.isCfgType(CfgTypeMask.Attribute)) {
            this.attrInfo = (CfgDescriptionAttributeReference)metadata;
            this.classInfo = this.attrInfo.getCfgClass();
        } else {
            this.attrInfo = null;
            this.classInfo = (CfgDescriptionClass)metadata;
        }
    }

    @Override
    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean truncate, boolean hideAllowed) {
        StringBuilder sb = new StringBuilder();
        this.toStringHelper(sb, "", truncate, hideAllowed);
        return sb.toString();
    }

    protected void toStringHelper(StringBuilder buffer, String prefix, boolean truncate, boolean hideAllowed) {
        String childPrefix = prefix + "\t";
        buffer.append(this.getClass().getSimpleName()).append("[").append(Integer.toString(this.size())).append(" item(s)] = {");
        for (int i = 0; i < this.size(); ++i) {
            buffer.append("\n").append(childPrefix).append("[").append(Integer.toString(i)).append("]: ");
            Object val = this.get(i);
            if (val instanceof ConfObjectBase) {
                ((ConfObjectBase)val).toStringHelper(buffer, childPrefix, truncate, hideAllowed);
                continue;
            }
            buffer.append(val);
        }
        if (this.size() > 0) {
            buffer.append("\n").append(prefix);
        }
        buffer.append("}");
    }

    public CfgDescriptionAttributeReference getAttributeInfo() {
        return this.attrInfo;
    }

    public CfgDescriptionClass getClassInfo() {
        return this.classInfo;
    }
}

