/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.binding;

import com.genesyslab.platform.commons.GEnum;
import com.genesyslab.platform.configuration.protocol.runtime.binding.Style;

public class CfgEnumConverter {
    static Style unsupported = Style.UNSUPPORTED;
    private static final String OBJECT_STYLE = "object";
    private static final String POBJECT_STYLE = "pobject";
    private static final String TIME_STYLE = "time";
    private static final String ULONG_STYLE = "ulong";
    private static final String GSTRING_STYLE = "gstring";
    private static final String STRING_STYLE = "string";
    private static final String OBJHASH = "objhash";
    private static final String POBJHASH = "pobjhash";
    private static final String OBJLIST = "objlist";
    private static final String STRLIST = "strlist";

    private CfgEnumConverter() {
    }

    public static Style parseStyleType(String styleType) {
        if (OBJECT_STYLE.equals(styleType)) {
            styleType = POBJECT_STYLE;
        } else if (TIME_STYLE.equals(styleType)) {
            styleType = ULONG_STYLE;
        } else if (GSTRING_STYLE.equals(styleType)) {
            styleType = STRING_STYLE;
        } else if (OBJHASH.equals(styleType) || POBJHASH.equals(styleType)) {
            styleType = OBJLIST;
        }
        GEnum enumVal = GEnum.getValue(Style.class, (String)styleType);
        if (enumVal == null) {
            enumVal = unsupported;
        }
        return (Style)enumVal;
    }

    public static String printStyleType(Style cfgStyleType) {
        return cfgStyleType.name();
    }
}

