/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class AesUtil {
    private static final byte[] KEY_MATERIAL = new byte[]{-6, 1, 114, -74, 23, 80, -105, -51, 11, 54, 68, -126, 99, -81, -103, 120};

    public String encrypt(String plainText) throws CodecException {
        return this.encrypt(plainText, null);
    }

    public String encrypt(String plainText, String encoding) throws CodecException {
        if (plainText == null) {
            return "";
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec key = new SecretKeySpec(KEY_MATERIAL, "AES");
            cipher.init(1, key);
            byte[] textBytes = encoding != null ? plainText.getBytes(encoding) : plainText.getBytes();
            byte[] cipherText = cipher.doFinal(textBytes);
            String encodedCipherText = new String(Hex.encodeHex((byte[])cipherText));
            return encodedCipherText.toUpperCase();
        }
        catch (GeneralSecurityException e) {
            throw new CodecException("Failed to configure cryptoprovider", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CodecException("String encoding usage error", (Throwable)e);
        }
    }

    public String decrypt(String cipherText) throws CodecException {
        return this.decrypt(cipherText, null);
    }

    public String decrypt(String cipherText, String encoding) throws CodecException {
        if (cipherText == null) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec key = new SecretKeySpec(KEY_MATERIAL, "AES");
            cipher.init(2, key);
            int l = cipherText.length();
            char[] cipherChars = new char[l];
            cipherText.getChars(0, l, cipherChars, 0);
            byte[] cipherBytes = Hex.decodeHex((char[])cipherChars);
            byte[] plainText = cipher.doFinal(cipherBytes);
            if (encoding != null) {
                return new String(plainText, encoding);
            }
            return new String(plainText);
        }
        catch (GeneralSecurityException e) {
            throw new CodecException("Failed to configure cryptoprovider", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CodecException("String encoding usage error", (Throwable)e);
        }
    }
}

