/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.commons.collections.util.Hex;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.xml.XmlUtil;
import com.genesyslab.platform.commons.xmlfactory.XmlFactories;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgOperation;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.runtime.channel.AesUtil;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReader;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ObjectSerializer
implements EncodingSupport {
    protected static final String KEY = "key";
    protected static final String VALUE = "value";
    protected static final String BINARY_PAIR = "bin_pair";
    protected static final String STRING_PAIR = "str_pair";
    protected static final String INTEGER_PAIR = "int_pair";
    protected static final String PASSWORD = "password";
    protected static final String DBID = "DBID";
    protected static final String INTID = "IntID";
    protected AesUtil aes;
    protected CfgMetadata metadata;
    protected boolean deltaCleanUp;
    protected String stringsEncoding = null;
    protected DocumentBuilder docCreator;
    protected static final ILogger dataLogger = Log.getDataLogger();

    protected ObjectSerializer(CfgMetadata metadata, AesUtil aes, boolean deltaCleanUp) {
        this.metadata = metadata;
        this.aes = aes;
        this.deltaCleanUp = true;
        try {
            this.docCreator = XmlFactories.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Exception on initialization of Document Builder", e);
        }
    }

    public CfgMetadata getMetadata() {
        return this.metadata;
    }

    public void setStringAttributesEncoding(String strEncoding) {
        this.stringsEncoding = strEncoding != null && !strEncoding.equals("") ? strEncoding : null;
    }

    public abstract Document serialize(String var1, String var2) throws CodecException;

    public abstract String deserialize(String var1, Document var2) throws CodecException;

    static void injectMissingElement(CfgDescriptionAttribute attribute, StringWriter cfgWriter) {
        cfgWriter.write(23);
        if (!attribute.isCfgType(CfgTypeMask.List) && !attribute.isCfgType(CfgTypeMask.String) && (attribute.isCfgType(CfgTypeMask.Primitive) || attribute.isCfgType(CfgTypeMask.Link))) {
            cfgWriter.write(25);
        }
        cfgWriter.write(24);
    }

    protected Element serializeKVPair(TokenReader tokenReader, Document document) throws CodecException {
        String elementName;
        TokenType tokenType = tokenReader.getTokenType();
        if (tokenType == TokenType.EMPTY) {
            return null;
        }
        String tokenKey = tokenReader.getKey();
        String tokenData = tokenReader.getData();
        String elementValue = null;
        if (tokenType == TokenType.STRING) {
            elementName = STRING_PAIR;
            if (PASSWORD.equals(tokenKey)) {
                elementValue = this.getDecrypted(tokenData);
            }
        } else if (tokenType == TokenType.INTEGER) {
            elementName = INTEGER_PAIR;
        } else if (tokenType == TokenType.BINARY) {
            elementName = BINARY_PAIR;
        } else {
            return null;
        }
        Element xmlElement = this.createElement(document, elementName);
        XmlUtil.setElementAttribute((Element)xmlElement, (String)KEY, (String)tokenKey);
        if (elementValue == null && tokenData != null) {
            elementValue = tokenType == TokenType.BINARY ? tokenData.toUpperCase() : tokenData;
        }
        XmlUtil.setElementAttribute((Element)xmlElement, (String)VALUE, (String)elementValue);
        return xmlElement;
    }

    protected Element createElement(Document document, String elementName) {
        String ns = CfgMetadata.getNs();
        if (ns == null) {
            ns = "";
        }
        return document.createElementNS(ns, elementName);
    }

    protected Element serializeKVListPair(TokenReader tokenReader, Document document) throws CodecException {
        Element kvlistpairXmlElement = this.createElement(document, "list_pair");
        XmlUtil.setElementAttribute((Element)kvlistpairXmlElement, (String)KEY, (String)tokenReader.getKey());
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            Element xmlElement = tokenReader.getTokenType() == TokenType.KVLIST ? this.serializeKVListPair(tokenReader, document) : this.serializeKVPair(tokenReader, document);
            if (xmlElement == null) continue;
            kvlistpairXmlElement.appendChild(xmlElement);
        }
        return kvlistpairXmlElement;
    }

    protected Element createXmlElement(CfgDescriptionAttribute attr, TokenReader tokenReader, Document document) throws CodecException {
        return this.createXmlElement(attr, tokenReader, document, false);
    }

    protected Element createXmlElement(CfgDescriptionAttribute attributeDescription, TokenReader tokenReader, Document document, boolean isAddedObjlistElement) throws CodecException {
        if (attributeDescription.isCfgType(CfgTypeMask.List)) {
            if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
                return this.serializeObjList((CfgDescriptionAttributeReference)attributeDescription, tokenReader, document);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.String)) {
                return this.serializeStrList((CfgDescriptionAttributeReference)attributeDescription, tokenReader, document);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.Integer)) {
                return this.serializeIntList(attributeDescription.getName(), tokenReader, document);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.Link)) {
                return this.serializeDBIDList(attributeDescription.getName(), tokenReader, document);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.KvList)) {
                return this.serializeKVList(attributeDescription.getName(), tokenReader, document);
            }
        } else {
            if (attributeDescription.isCfgType(CfgTypeMask.Primitive) || attributeDescription.isCfgType(CfgTypeMask.Link)) {
                return this.serializePrimitive(attributeDescription.getName(), tokenReader, document, isAddedObjlistElement);
            }
            if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
                return this.serializePObject((CfgDescriptionAttributeReference)attributeDescription, tokenReader, document);
            }
        }
        return null;
    }

    protected Element serializePrimitive(String name, TokenReader tokenReader, Document document) throws CodecException {
        return this.serializePrimitive(name, tokenReader, document, false);
    }

    protected Element serializePrimitive(String name, TokenReader tokenReader, Document document, boolean isAddedObjlistElement) throws CodecException {
        Element xmlElement;
        Element element = xmlElement = this.deltaCleanUp ? null : this.createElement(document, name);
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return xmlElement;
        }
        String value = tokenReader.getData();
        if (value == null) {
            value = "";
        }
        if (tokenReader.getTokenType() == TokenType.STRING) {
            if (PASSWORD.equals(name) && tokenReader.getData() != null) {
                value = this.getDecrypted(value);
            }
        } else if (tokenReader.isDelta() && !isAddedObjlistElement && this.deltaCleanUp) {
            int iVal = 0;
            if (!value.equals("")) {
                try {
                    iVal = Integer.parseInt(value);
                }
                catch (Exception ex) {
                    throw new CodecException("Error parsing int value '" + value + "'", (Throwable)ex);
                }
            }
            if (iVal == 0) {
                value = null;
            }
        }
        if (value != null) {
            if (xmlElement == null) {
                xmlElement = this.createElement(document, name);
            }
            XmlUtil.setElementAttribute((Element)xmlElement, (String)VALUE, (String)value);
        }
        return xmlElement;
    }

    protected Element serializeIntList(String name, TokenReader tokenReader, Document document) {
        Element intlistXmlElement;
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        Element element = intlistXmlElement = this.deltaCleanUp ? null : this.createElement(document, name);
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            Element xmlElement = this.createElement(document, INTID);
            XmlUtil.setElementAttribute((Element)xmlElement, (String)VALUE, (String)tokenReader.getData());
            if (intlistXmlElement == null) {
                intlistXmlElement = this.createElement(document, name);
            }
            intlistXmlElement.appendChild(xmlElement);
        }
        return intlistXmlElement;
    }

    protected Element serializeDBIDList(String name, TokenReader tokenReader, Document document) {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        Node dbidlistXmlElement = null;
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            if (tokenReader.getTokenType() == TokenType.EMPTY) continue;
            Element xmlElement = this.createElement(document, DBID);
            XmlUtil.setElementAttribute((Element)xmlElement, (String)VALUE, (String)tokenReader.getData());
            if (dbidlistXmlElement == null) {
                dbidlistXmlElement = this.createElement(document, name);
            }
            dbidlistXmlElement.appendChild(xmlElement);
        }
        return dbidlistXmlElement;
    }

    protected Element serializeObjList(CfgDescriptionAttributeReference attr, TokenReader tokenReader, Document document) throws CodecException {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        Node objlistXmlElement = null;
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            Element xmlElement;
            if (tokenReader.getTokenType() == TokenType.EMPTY) continue;
            boolean isAdded = false;
            if (attr.getOperation() == CfgOperation.Unknown || attr.getOperation() == CfgOperation.Add) {
                isAdded = true;
            }
            if ((xmlElement = this.serializePObject(attr, tokenReader, document, isAdded)) == null) continue;
            if (objlistXmlElement == null) {
                objlistXmlElement = this.createElement(document, attr.getName());
            }
            objlistXmlElement.appendChild(xmlElement);
        }
        return objlistXmlElement;
    }

    protected Element serializePObject(CfgDescriptionAttributeReference attr, TokenReader tokenReader, Document document) throws CodecException {
        return this.serializePObject(attr, tokenReader, document, false);
    }

    protected Element serializePObject(CfgDescriptionAttributeReference attr, TokenReader tokenReader, Document document, boolean isAddedObjlistElement) throws CodecException {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        CfgDescriptionClass classDescription = attr.getCfgClass();
        Node pobjectXmlElement = null;
        for (CfgDescriptionAttribute attribute : classDescription.getAttributes()) {
            Element xmlElement;
            if (!tokenReader.read()) break;
            if (tokenReader.getTokenType() == TokenType.EMPTY && tokenReader.getData() == null || (xmlElement = this.createXmlElement(attribute, tokenReader, document, isAddedObjlistElement)) == null) continue;
            if (pobjectXmlElement == null) {
                pobjectXmlElement = this.createElement(document, classDescription.getName());
            }
            pobjectXmlElement.appendChild(xmlElement);
        }
        tokenReader.read();
        return pobjectXmlElement;
    }

    protected Element serializeKVList(String name, TokenReader tokenReader, Document document) throws CodecException {
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            if (tokenReader.getData() == null) {
                return null;
            }
            return this.createElement(document, name);
        }
        Element kvlistXmlElement = null;
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            if (kvlistXmlElement == null) {
                kvlistXmlElement = this.createElement(document, name);
            }
            Element xmlElement = tokenReader.getTokenType() == TokenType.KVLIST ? this.serializeKVListPair(tokenReader, document) : this.serializeKVPair(tokenReader, document);
            if (kvlistXmlElement == null || xmlElement == null) continue;
            kvlistXmlElement.appendChild(xmlElement);
        }
        return kvlistXmlElement;
    }

    protected Element serializeStrList(CfgDescriptionAttributeReference attr, TokenReader tokenReader, Document document) {
        Element strlistXmlElement;
        if (tokenReader.getTokenType() == TokenType.EMPTY) {
            return null;
        }
        Element element = strlistXmlElement = this.deltaCleanUp ? null : this.createElement(document, attr.getName());
        while (tokenReader.read() && tokenReader.getTokenType() != TokenType.END) {
            Element xmlElement = this.createElement(document, attr.getName());
            xmlElement.setAttribute(VALUE, tokenReader.getData());
            if (strlistXmlElement == null) {
                strlistXmlElement = this.createElement(document, attr.getName());
            }
            strlistXmlElement.appendChild(xmlElement);
        }
        return strlistXmlElement;
    }

    protected abstract boolean deserializeKVList(String var1, DocumentWalker var2, StringWriter var3) throws CodecException;

    protected abstract boolean deserializeIntList(String var1, DocumentWalker var2, StringWriter var3) throws CodecException;

    protected abstract boolean deserializeDBIdList(String var1, DocumentWalker var2, StringWriter var3) throws CodecException;

    protected abstract boolean deserializeObjList(CfgDescriptionAttributeReference var1, DocumentWalker var2, StringWriter var3) throws CodecException;

    protected abstract boolean deserializePObject(CfgDescriptionAttributeReference var1, DocumentWalker var2, StringWriter var3) throws CodecException;

    protected abstract boolean deserializePrimitive(String var1, char var2, DocumentWalker var3, StringWriter var4) throws CodecException;

    protected abstract boolean writeCfgString(CfgDescriptionAttribute var1, DocumentWalker var2, StringWriter var3) throws CodecException;

    protected String getEncrypted(String val) throws CodecException {
        return this.aes != null ? this.aes.encrypt(val, this.stringsEncoding) : val;
    }

    protected String getDecrypted(String val) throws CodecException {
        if (val == null) {
            return null;
        }
        return this.aes != null ? this.aes.decrypt(val, this.stringsEncoding) : val;
    }

    protected String createTruncatedLogTrace(String strData) {
        if (strData != null) {
            String hex;
            String str = strData;
            int len = str.length();
            if (len >= 150) {
                String str1 = str.substring(0, 50);
                String str2 = str.substring(len - 50);
                str = str1 + " <...> " + str2;
                hex = new String(Hex.encodeHex((byte[])str1.getBytes())) + "..." + new String(Hex.encodeHex((byte[])str2.getBytes()));
            } else {
                hex = new String(Hex.encodeHex((byte[])str.getBytes()));
            }
            return "length=" + len + ": " + str + " {" + hex + "}";
        }
        return "NULL";
    }

    protected static class DocumentWalker {
        private Element element;

        public DocumentWalker(Element element) {
            this.element = element;
        }

        public Element getElement() {
            return this.element;
        }

        public Element moveToFirstChild() {
            this.element = XmlUtil.getFirstChild((Element)this.element);
            return this.element;
        }

        public Element moveToParent() {
            this.element = (Element)this.element.getParentNode();
            return this.element;
        }

        public boolean moveToNext() {
            Element nextElement = XmlUtil.getNextSibling((Element)this.element);
            if (nextElement != null) {
                this.element = nextElement;
            }
            return nextElement != null;
        }

        public boolean hasChildren() {
            return this.element.hasChildNodes();
        }

        public boolean hasAttributes() {
            return this.element.hasAttributes();
        }

        public boolean hasAttribute(String name) {
            return this.element.hasAttribute(name);
        }

        public String getName() {
            return this.element.getNodeName();
        }

        public String getAttribute(String attrName) {
            return this.element.getAttribute(attrName);
        }
    }
}

