/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.commons.log.ILogger;
import com.genesyslab.platform.commons.log.Log;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescription;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttribute;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionAttributeReference;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionClass;
import com.genesyslab.platform.configuration.protocol.metadata.CfgDescriptionStructure;
import com.genesyslab.platform.configuration.protocol.metadata.CfgMetadata;
import com.genesyslab.platform.configuration.protocol.metadata.CfgTypeMask;
import com.genesyslab.platform.configuration.protocol.runtime.channel.AesUtil;
import com.genesyslab.platform.configuration.protocol.runtime.channel.ObjectSerializer;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReader;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReaderV7;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;
import java.io.StringWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectSerializerV7
extends ObjectSerializer {
    private static ILogger log = Log.getLogger(ObjectSerializerV7.class);
    private static final String DELTA_PREFIX = "CfgDelta";

    public ObjectSerializerV7(CfgMetadata metadata, AesUtil aes, boolean deltaCleanUp) {
        super(metadata, aes, deltaCleanUp);
    }

    public Document serialize(String objectTypeName, String cfgStr) throws CodecException {
        if (log.isDebug()) {
            log.debugFormat("serializing: {0}", (Object)this.createTruncatedLogTrace(cfgStr));
        }
        if (dataLogger.isDebug()) {
            dataLogger.debugFormat("serializing: {0}", (Object)cfgStr);
        }
        Document document = this.docCreator.newDocument();
        Element xmlElement = this.createElement(document, "ConfData");
        document.appendChild(xmlElement);
        Object classDescription = this.getMetadata().getCfgClass(objectTypeName);
        TokenReaderV7 tokenReader = new TokenReaderV7(cfgStr, objectTypeName.startsWith(DELTA_PREFIX));
        while (((TokenReader)tokenReader).read()) {
            Element xmlObjectElement = this.createElement(document, ((CfgDescription)classDescription).getName());
            for (CfgDescriptionAttribute attribute : ((CfgDescriptionClass)classDescription).getAttributes()) {
                if (!((TokenReader)tokenReader).read()) {
                    return document;
                }
                if (tokenReader.getTokenType() == TokenType.EMPTY && tokenReader.getData() == null || (xmlElement = this.createXmlElement(attribute, tokenReader, document)) == null) continue;
                xmlObjectElement.appendChild(xmlElement);
            }
            document.getDocumentElement().appendChild(xmlObjectElement);
            if (!"cfglib_schema".equals(((CfgDescription)classDescription).getName()) && ((TokenReader)tokenReader).read()) continue;
        }
        return document;
    }

    public String deserialize(String objectTypeName, Document document) throws CodecException {
        StringWriter cfgWriter = new StringWriter();
        Object typeDescription = this.getMetadata().getCfgClass(objectTypeName);
        cfgWriter.write(23);
        cfgWriter.write(31);
        ObjectSerializer.DocumentWalker navigator = new ObjectSerializer.DocumentWalker(document.getDocumentElement());
        navigator.moveToFirstChild();
        if (navigator.hasChildren()) {
            navigator.moveToFirstChild();
            boolean nextMove = true;
            for (CfgDescriptionAttribute attribute : ((CfgDescriptionClass)typeDescription).getAttributes()) {
                if (nextMove) {
                    nextMove = this.writeCfgString(attribute, navigator, cfgWriter);
                    continue;
                }
                ObjectSerializerV7.injectMissingElement(attribute, cfgWriter);
            }
        }
        cfgWriter.write(24);
        String s = cfgWriter.toString();
        if (log.isDebug()) {
            log.debugFormat("deserialized to: {0}", (Object)this.createTruncatedLogTrace(s));
        }
        if (dataLogger.isDebug()) {
            dataLogger.debugFormat("deserialized dump: {0}", (Object)s);
        }
        return s;
    }

    protected void deserializeKVPair(ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(23);
        Element element = navigator.getElement();
        if (element.hasAttributes()) {
            cfgWriter.write(element.getAttribute("key"));
            if ("str_pair".equals(navigator.getName())) {
                cfgWriter.write(27);
            } else if ("int_pair".equals(navigator.getName())) {
                cfgWriter.write(25);
            } else if ("bin_pair".equals(navigator.getName())) {
                cfgWriter.write(30);
            }
            if ("bin_pair".equals(navigator.getName())) {
                cfgWriter.write(element.getAttribute("value").toLowerCase());
            } else if ("str_pair".equals(navigator.getName()) && navigator.getAttribute("key").equals("password")) {
                String encryptedValue = this.getEncrypted(navigator.getAttribute("value"));
                cfgWriter.write(encryptedValue);
            } else {
                cfgWriter.write(element.getAttribute("value"));
            }
        }
        cfgWriter.write(24);
    }

    protected void deserializeKVListPair(ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        cfgWriter.write(23);
        if (navigator.hasAttribute("key")) {
            cfgWriter.write(navigator.getAttribute("key"));
        }
        cfgWriter.write(29);
        if (navigator.hasChildren()) {
            navigator.moveToFirstChild();
            do {
                if ("list_pair".equals(navigator.getName())) {
                    this.deserializeKVListPair(navigator, cfgWriter);
                    continue;
                }
                this.deserializeKVPair(navigator, cfgWriter);
            } while (navigator.moveToNext());
            navigator.moveToParent();
        }
        cfgWriter.write(24);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean writeCfgString(CfgDescriptionAttribute attributeDescription, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean navigatorMoveToNext = false;
        if (attributeDescription.isCfgType(CfgTypeMask.List)) {
            if (attributeDescription.isCfgType(CfgTypeMask.Class)) {
                navigatorMoveToNext = this.deserializeObjList((CfgDescriptionAttributeReference)attributeDescription, navigator, cfgWriter);
            } else if (attributeDescription.isCfgType(CfgTypeMask.Integer)) {
                navigatorMoveToNext = this.deserializeIntList(attributeDescription.getName(), navigator, cfgWriter);
            } else if (attributeDescription.isCfgType(CfgTypeMask.String)) {
                navigatorMoveToNext = this.deserializeStrList(attributeDescription.getName(), navigator, cfgWriter);
            } else if (attributeDescription.isCfgType(CfgTypeMask.Link)) {
                navigatorMoveToNext = this.deserializeDBIdList(attributeDescription.getName(), navigator, cfgWriter);
            } else {
                if (!attributeDescription.isCfgType(CfgTypeMask.KvList)) return false;
                navigatorMoveToNext = this.deserializeKVList(attributeDescription.getName(), navigator, cfgWriter);
            }
        } else if (attributeDescription.isCfgType(CfgTypeMask.Integer) || attributeDescription.isCfgType(CfgTypeMask.Link) || attributeDescription.isCfgType(CfgTypeMask.Enum)) {
            navigatorMoveToNext = this.deserializePrimitive(attributeDescription.getName(), '\u0019', navigator, cfgWriter);
        } else if (attributeDescription.isCfgType(CfgTypeMask.String)) {
            navigatorMoveToNext = this.deserializePrimitive(attributeDescription.getName(), '\u001b', navigator, cfgWriter);
        } else {
            if (!attributeDescription.isCfgType(CfgTypeMask.Class)) return false;
            navigatorMoveToNext = this.deserializePObject((CfgDescriptionAttributeReference)attributeDescription, navigator, cfgWriter);
        }
        if (!navigatorMoveToNext) return true;
        if (!navigator.moveToNext()) return false;
        return true;
    }

    private boolean deserializeStrList(String name, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean attrExists = false;
        cfgWriter.write(23);
        if (name.equals(navigator.getName())) {
            if (navigator.hasChildren()) {
                cfgWriter.write(28);
                navigator.moveToFirstChild();
                do {
                    this.deserializePrimitive(navigator.getName(), '\u001b', navigator, cfgWriter);
                } while (navigator.moveToNext());
                navigator.moveToParent();
            }
            attrExists = true;
        }
        cfgWriter.write(24);
        return attrExists;
    }

    protected boolean deserializePrimitive(String name, char delimiter, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean attrExists = false;
        cfgWriter.write(23);
        Element element = navigator.getElement();
        if (name.equals(element.getNodeName())) {
            cfgWriter.write(delimiter);
            if (delimiter == '\u001b' && "password".equals(name)) {
                String encryptedValue = this.getEncrypted(element.getAttribute("value"));
                cfgWriter.write(encryptedValue);
            } else {
                cfgWriter.write(element.getAttribute("value"));
            }
            attrExists = true;
        } else if (delimiter != '\u001b') {
            cfgWriter.write(delimiter);
        }
        cfgWriter.write(24);
        return attrExists;
    }

    protected boolean deserializeIntList(String name, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        return this.deserializeDBIdList(name, navigator, cfgWriter);
    }

    protected boolean deserializeDBIdList(String name, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean attrExists = false;
        cfgWriter.write(23);
        if (name.equals(navigator.getName())) {
            if (navigator.hasChildren()) {
                cfgWriter.write(28);
                navigator.moveToFirstChild();
                do {
                    this.deserializePrimitive(navigator.getName(), '\u0019', navigator, cfgWriter);
                } while (navigator.moveToNext());
                navigator.moveToParent();
            }
            attrExists = true;
        }
        cfgWriter.write(24);
        return attrExists;
    }

    protected boolean deserializeObjList(CfgDescriptionAttributeReference attr, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean attrExists = false;
        cfgWriter.write(23);
        if (attr.getName().equals(navigator.getName())) {
            if (navigator.hasChildren()) {
                cfgWriter.write(28);
                navigator.moveToFirstChild();
                do {
                    this.deserializePObject(attr, navigator, cfgWriter);
                } while (navigator.moveToNext());
                navigator.moveToParent();
            }
            attrExists = true;
        }
        cfgWriter.write(24);
        return attrExists;
    }

    protected boolean deserializePObject(CfgDescriptionAttributeReference attr, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean attrExists = false;
        cfgWriter.write(23);
        CfgDescriptionClass classDescription = attr.getCfgClass();
        String navName = navigator.getName();
        if (navName != null && navName.equals(classDescription.getName()) || classDescription.isCfgType(CfgTypeMask.Structure) && navName.equals(((CfgDescriptionStructure)classDescription).getAliasName())) {
            if (navigator.hasChildren()) {
                cfgWriter.write(31);
                navigator.moveToFirstChild();
                boolean toContinue = true;
                for (CfgDescriptionAttribute attribute : classDescription.getAttributes()) {
                    if (toContinue) {
                        toContinue = this.writeCfgString(attribute, navigator, cfgWriter);
                        continue;
                    }
                    ObjectSerializerV7.injectMissingElement(attribute, cfgWriter);
                }
                navigator.moveToParent();
            }
            attrExists = true;
        }
        cfgWriter.write(24);
        return attrExists;
    }

    protected boolean deserializeKVList(String name, ObjectSerializer.DocumentWalker navigator, StringWriter cfgWriter) throws CodecException {
        boolean attrExists = false;
        cfgWriter.write(23);
        if (name.equals(navigator.getName())) {
            cfgWriter.write(29);
            if (navigator.hasChildren()) {
                navigator.moveToFirstChild();
                do {
                    if ("list_pair".equals(navigator.getName())) {
                        this.deserializeKVListPair(navigator, cfgWriter);
                        continue;
                    }
                    this.deserializeKVPair(navigator, cfgWriter);
                } while (navigator.moveToNext());
                navigator.moveToParent();
            }
            attrExists = true;
        }
        cfgWriter.write(24);
        return attrExists;
    }
}

