/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.channel;

import com.genesyslab.platform.configuration.protocol.runtime.channel.CharDelimitersV6;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenReader;
import com.genesyslab.platform.configuration.protocol.runtime.channel.TokenType;

public class TokenReaderV6
extends TokenReader {
    public TokenReaderV6(String cfgStr) {
        super(cfgStr);
    }

    public boolean read() {
        TokenType tokenType;
        if (this.position > this.confStr.length() - 1) {
            return false;
        }
        int startPosition = this.position;
        String tokenData = null;
        this.position = CharDelimitersV6.indexOfAnyDelimiter(this.confStr, startPosition);
        if (this.confStr.charAt(this.position) != '\u0018') {
            if (this.position == startPosition) {
                TokenType tokenType2 = this.getTokenType(this.position);
                this.setToken(tokenType2, tokenData);
                ++this.position;
                return true;
            }
        } else if (this.confStr.charAt(++this.position) == '\u001d') {
            TokenType tokenType3 = TokenType.STRUCT;
            this.setToken(tokenType3, tokenData);
            ++this.position;
            return true;
        }
        this.position = this.confStr.indexOf(61, startPosition);
        int dataPosition = ++this.position;
        this.position = CharDelimitersV6.indexOfAnyDelimiter(this.confStr, dataPosition);
        if (this.position > dataPosition && (this.confStr.charAt(this.position) == '\u0018' || this.confStr.charAt(this.position) == '\u001e' || this.confStr.charAt(this.position) == '\u001c')) {
            tokenType = TokenType.INTEGER;
            tokenData = this.confStr.substring(dataPosition, this.position);
            if ("NIL".equals(tokenData)) {
                tokenData = null;
                tokenType = TokenType.EMPTY;
            } else if (Character.isLetter(tokenData.charAt(0))) {
                tokenType = this.getTokenType(++this.position);
                ++this.position;
            }
        } else {
            tokenType = this.getTokenType(this.position);
            dataPosition = ++this.position;
            if (tokenType == TokenType.STRING) {
                this.position = this.confStr.indexOf(31, dataPosition);
                tokenData = this.confStr.substring(dataPosition, this.position);
                this.position += 2;
            }
        }
        this.setToken(tokenType, tokenData);
        return true;
    }

    protected TokenType getTokenType(int position) {
        return CharDelimitersV6.getTokenType(this.confStr.charAt(position));
    }

    protected void readKVPair() {
        String tokenKey = null;
        String tokenData = null;
        int keyPosition = this.position++;
        if (this.confStr.charAt(this.position) == '\u0019') {
            this.setToken(TokenType.KVLIST, null, null);
        } else {
            this.position = CharDelimitersV6.indexOfAnyDelimiter(this.confStr, keyPosition);
            if (this.position > keyPosition) {
                tokenKey = this.confStr.substring(keyPosition, this.position);
            }
            if (this.confStr.charAt(this.position) == '\u0018') {
                this.setToken(TokenType.KVLIST, null, tokenKey);
                --this.position;
            } else if (this.confStr.charAt(++this.position) == '\u001f') {
                this.setToken(TokenType.KVLIST, null, tokenKey);
            } else if (this.confStr.charAt(this.position) == '\u001a') {
                if (tokenKey == null) {
                    this.setToken(TokenType.EMPTY, null, null);
                } else {
                    this.setToken(TokenType.KVLIST, null, tokenKey);
                    --this.position;
                }
            } else {
                int dataPosition = this.position;
                this.position = this.confStr.indexOf(24, dataPosition + 1);
                if (this.position > dataPosition) {
                    tokenData = this.confStr.substring(dataPosition, this.position);
                }
                this.setToken(this.getTokenType(dataPosition - 1), tokenData, tokenKey);
            }
        }
    }
}

