/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.connection.impl.EncodingSupport;
import com.genesyslab.platform.commons.protocol.Message;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.xml.XmlUtil;
import com.genesyslab.platform.configuration.protocol.runtime.channel.AesUtil;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.w3c.dom.Element;

public class AesCodec
implements AttributeTypeCodec,
EncodingSupport {
    private AesUtil aes;
    private String stringEncoding = null;

    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        String val = (String)customTypeObject;
        if (val != null) {
            String encrypted = this.getEncrypted(val);
            transport.onAttribute(transportState, id, encrypted);
        }
        return transportState;
    }

    public String getNS() {
        return null;
    }

    public void setStringAttributesEncoding(String stringAttributesEncoding) {
        this.stringEncoding = stringAttributesEncoding;
    }

    public Object decodeFromConnection(Object value, AttributeDescription attributeDescription) throws PlatformException {
        String encrypted = (String)value;
        return this.aes != null ? this.aes.decrypt(encrypted, this.stringEncoding) : encrypted;
    }

    public void encodeToXml(Object customTypeObject, Result attributeElement) throws CodecException {
        String val = (String)customTypeObject;
        CodecUtil.appendText((String)val, (Result)attributeElement);
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        return XmlUtil.getElementText((Element)CodecUtil.asElement((Source)attributeElement));
    }

    public String getLogType() {
        return "AesString";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) throws CodecException {
        if (!hide) {
            String val = (String)customTypeObject;
            String encrypted = this.getEncrypted(val);
            buf.append(encrypted);
        } else {
            buf.append("[output suppressed]");
        }
    }

    public void setProtocolData(Object protocolData) {
        if (protocolData instanceof AesUtilityStorage) {
            this.aes = ((AesUtilityStorage)protocolData).getConfAesUtility();
        }
    }

    public void setMessage(Message message) {
    }

    private String getEncrypted(String val) throws CodecException {
        return this.aes != null ? this.aes.encrypt(val, this.stringEncoding) : val;
    }

    public static interface AesUtilityStorage {
        public AesUtil getConfAesUtility();
    }
}

