/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.runtime.codec;

import com.genesyslab.platform.commons.PlatformException;
import com.genesyslab.platform.commons.connection.MessageTransport;
import com.genesyslab.platform.commons.protocol.runtime.AttributeDescription;
import com.genesyslab.platform.commons.protocol.runtime.codec.AttributeTypeCodec;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecException;
import com.genesyslab.platform.commons.protocol.runtime.codec.CodecUtil;
import com.genesyslab.platform.commons.protocol.runtime.codec.NoDataCodec;
import com.genesyslab.platform.commons.xml.XmlUtil;
import com.genesyslab.platform.configuration.protocol.ConfServerProtocol;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbidArrayCodec
extends NoDataCodec
implements AttributeTypeCodec {
    public Object encodeForConnection(Object customTypeObject, String id, MessageTransport transport, Object transportState) throws PlatformException {
        throw new UnsupportedOperationException("dbid can't be sent to server");
    }

    public Object decodeFromConnection(Object value, AttributeDescription attributeDescription) throws PlatformException {
        String val = (String)value;
        if (val == null) {
            return null;
        }
        String[] split = val.split("\b");
        return this.parseDbidArray(split);
    }

    public void encodeToXml(Object customTypeObject, Result result) throws CodecException {
        long[] ids = (long[])customTypeObject;
        if (ids.length > 0) {
            if (result instanceof DOMResult) {
                DOMResult dom = (DOMResult)result;
                Node node = dom.getNode();
                Document doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
                for (long id : ids) {
                    Element element = doc.createElementNS(ConfServerProtocol.PROTOCOL_DESCRIPTION.getNS(), "Dbid");
                    XmlUtil.appendText((Element)element, (String)String.valueOf(id));
                    CodecUtil.appendElement((Element)element, (Result)result);
                }
            } else {
                throw new CodecException("DomResult supported only");
            }
        }
    }

    public Object decodeFromXml(Source attributeElement, AttributeDescription attributeDescription) throws CodecException {
        Element elem = CodecUtil.asElement((Source)attributeElement);
        NodeList ids = elem.getChildNodes();
        int length = ids.getLength();
        if (length == 0) {
            return new long[0];
        }
        long[] dbArr = new long[length];
        for (int i = 0; i < length; ++i) {
            Element id = (Element)ids.item(i);
            try {
                dbArr[i] = Long.parseLong(XmlUtil.getElementText((Element)id));
                continue;
            }
            catch (NumberFormatException e) {
                throw new CodecException("Failed to parse long", (Throwable)e);
            }
        }
        return dbArr;
    }

    public String getLogType() {
        return "str";
    }

    public void appendLogValue(StringBuffer buf, Object customTypeObject, boolean truncate, boolean hide) throws CodecException {
        this.toString(customTypeObject, buf);
    }

    private long[] parseDbidArray(String[] dbidArrStr) {
        long[] arr = new long[dbidArrStr.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = Long.parseLong(dbidArrStr[i]);
        }
        return arr;
    }

    private void toString(Object customTypeObject, StringBuffer buf) {
        long[] value = (long[])customTypeObject;
        buf.append('[');
        for (long l : value) {
            buf.append(l).append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append(']');
    }
}

