/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.configuration.protocol.utilities;

import com.genesyslab.platform.configuration.protocol.metadata.CfgComparer;
import com.genesyslab.platform.configuration.protocol.utilities.LinqConditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Linq {
    public static <T> T first(Collection<T> list, LinqConditions<T> cnd) {
        for (T cdc : list) {
            if (cnd != null && !cnd.condition(cdc)) continue;
            return cdc;
        }
        return null;
    }

    public static Node first(NodeList list, LinqConditions<Node> cnd) {
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node elem = list.item(i);
                if (cnd != null && !cnd.condition(elem)) continue;
                return elem;
            }
        }
        return null;
    }

    public static Node firstOrDefault(NodeList list, LinqConditions<Node> cnd) {
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node elem = list.item(i);
                if (cnd != null && !cnd.condition(elem)) continue;
                return elem;
            }
        }
        return null;
    }

    public static <T> T firstOrDefault(Collection<T> list, LinqConditions<T> cnd) {
        for (T cdc : list) {
            if (cnd != null && !cnd.condition(cdc)) continue;
            return cdc;
        }
        return null;
    }

    public static <T> List<T> select(Collection<T> list, LinqConditions<T> cnd) {
        LinkedList<T> result = new LinkedList<T>();
        for (T cdc : list) {
            if (cnd != null && !cnd.condition(cdc)) continue;
            result.add(cdc);
        }
        return result;
    }

    public static <T> List<T> selectWithOrder(Collection<T> list, LinqConditions<T> cnd) {
        List<T> result = Linq.select(list, cnd);
        Collections.sort(result, cnd);
        return result;
    }

    public static List<Node> selectWithOrder(NodeList xNodes, LinqConditions<Node> cnd) {
        LinkedList<Node> result = new LinkedList<Node>();
        if (xNodes != null) {
            for (int i = 0; i < xNodes.getLength(); ++i) {
                Node item = xNodes.item(i);
                if (cnd != null && !cnd.condition(item)) continue;
                result.add(item);
            }
        }
        Collections.sort(result, cnd);
        return result;
    }

    public static List<Node> select(NodeList xNodes, LinqConditions<Node> cnd) {
        LinkedList<Node> result = new LinkedList<Node>();
        if (xNodes != null) {
            for (int i = 0; i < xNodes.getLength(); ++i) {
                Node item = xNodes.item(i);
                if (cnd != null && !cnd.condition(item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    public static List<Node> except(Collection<? extends Node> xNodes, Collection<? extends Node> yNodes, CfgComparer comparer) {
        LinkedList<Node> result = new LinkedList<Node>();
        for (Node node : xNodes) {
            boolean foundY = false;
            for (Node node2 : yNodes) {
                if (!comparer.equals(node, node2)) continue;
                foundY = true;
            }
            if (foundY) continue;
            result.add(node);
        }
        return result;
    }

    public static List<Node> except(Collection<Node> xNodes, NodeList yNodes, CfgComparer comparer) {
        LinkedList<Node> result = new LinkedList<Node>();
        Node[] yNds = null;
        if (yNodes != null) {
            yNds = new Node[yNodes.getLength()];
            for (int i = 0; i < yNds.length; ++i) {
                yNds[i] = yNodes.item(i);
            }
        }
        for (Node xNode : xNodes) {
            boolean foundY = false;
            if (yNds != null) {
                for (Node yNode : yNds) {
                    if (!comparer.equals(xNode, yNode)) continue;
                    foundY = true;
                }
            }
            if (foundY) continue;
            result.add(xNode);
        }
        return result;
    }

    public static List<Node> except(NodeList xNodes, NodeList yNodes, CfgComparer comparer) {
        LinkedList<Node> result = new LinkedList<Node>();
        if (xNodes != null) {
            int i;
            int xNodesNum = xNodes.getLength();
            Node[] yNds = null;
            if (xNodesNum > 0 && yNodes != null) {
                yNds = new Node[yNodes.getLength()];
                for (i = 0; i < yNds.length; ++i) {
                    yNds[i] = yNodes.item(i);
                }
            }
            for (i = 0; i < xNodesNum; ++i) {
                Node xNode = xNodes.item(i);
                boolean foundY = false;
                if (yNds != null) {
                    for (Node yNode : yNds) {
                        if (!comparer.equals(xNode, yNode)) continue;
                        foundY = true;
                    }
                }
                if (foundY) continue;
                result.add(xNode);
            }
        }
        return result;
    }

    public static List<Node> intersect(NodeList xNodes, NodeList yNodes, CfgComparer comparer) {
        LinkedList<Node> result = new LinkedList<Node>();
        if (xNodes != null) {
            int i;
            int xNodesNum = xNodes.getLength();
            Node[] yNds = null;
            if (xNodesNum > 0 && yNodes != null) {
                yNds = new Node[yNodes.getLength()];
                for (i = 0; i < yNds.length; ++i) {
                    yNds[i] = yNodes.item(i);
                }
            }
            for (i = 0; i < xNodesNum; ++i) {
                Node xNode = xNodes.item(i);
                boolean foundY = false;
                if (yNds != null) {
                    for (Node yNode : yNds) {
                        if (!comparer.equals(xNode, yNode)) continue;
                        foundY = true;
                    }
                }
                if (!foundY) continue;
                result.add(xNode);
            }
        }
        return result;
    }

    public static boolean sequenceEqual(Collection<Node> xNodes, Collection<Node> yNodes, CfgComparer comparer) {
        if (xNodes == null && yNodes == null) {
            return true;
        }
        if (xNodes == null || yNodes == null) {
            return false;
        }
        if (xNodes.size() != yNodes.size()) {
            return false;
        }
        for (Node xNode : xNodes) {
            boolean foundY = false;
            for (Node yNode : yNodes) {
                if (!comparer.equals(xNode, yNode)) continue;
                foundY = true;
                break;
            }
            if (foundY) continue;
            return false;
        }
        for (Node yNode : yNodes) {
            boolean foundX = false;
            for (Node xNode : xNodes) {
                if (!comparer.equals(yNode, xNode)) continue;
                foundX = true;
                break;
            }
            if (foundX) continue;
            return false;
        }
        return true;
    }
}

