/*
 * Decompiled with CFR 0.152.
 */
package com.genesyslab.platform.commons;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GEnum {
    private static final Map<String, Map<Object, ? extends GEnum>> registry = new HashMap<String, Map<Object, ? extends GEnum>>();
    private Integer ordinal;
    private String name;

    protected GEnum(int ordinal, String name, Class enumClass) {
        this.ordinal = ordinal;
        this.name = name;
        GEnum.checkClass(enumClass);
        this.registerInstance(enumClass);
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof GEnum && this.getClass() == obj.getClass() && this.ordinal.equals(((GEnum)obj).ordinal);
    }

    public int hashCode() {
        return this.ordinal * 27 + this.name.hashCode() * 23 + this.getClass().hashCode();
    }

    public static Collection values(Class enumClass) {
        Map<Object, ? extends GEnum> classRegistry = GEnum.getEnumValues(enumClass);
        if (classRegistry == null) {
            return Collections.EMPTY_LIST;
        }
        return classRegistry.values();
    }

    public static <E extends GEnum> Collection<E> valuesBy(Class<E> enumClass) {
        return GEnum.values(enumClass);
    }

    public static int enumSize(Class enumClass) {
        Map<Object, ? extends GEnum> classRegistry = GEnum.getEnumValues(enumClass);
        if (classRegistry == null) {
            return 0;
        }
        return classRegistry.size() / 2;
    }

    public static GEnum getValue(Class enumClass, Integer ordinal) {
        return GEnum.getValueBy(enumClass, ordinal);
    }

    public static GEnum getValue(Class enumClass, int ordinal) {
        return GEnum.getValueBy(enumClass, ordinal);
    }

    public static GEnum getValue(Class enumClass, String name) {
        return GEnum.getValueBy(enumClass, name.toLowerCase());
    }

    private static GEnum getValueBy(Class enumClass, Object key) {
        Map<Object, ? extends GEnum> classRegistry = GEnum.getEnumValues(enumClass);
        if (classRegistry == null) {
            return null;
        }
        return classRegistry.get(key);
    }

    public Integer asInteger() {
        return this.ordinal;
    }

    private static Map<Object, ? extends GEnum> getEnumValues(Class enumClass) {
        GEnum.checkClass(enumClass);
        Map<Object, ? extends GEnum> enumValues = registry.get(enumClass.getName());
        if (enumValues == null) {
            try {
                enumClass.getFields()[0].get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            enumValues = registry.get(enumClass.getName());
        }
        return enumValues;
    }

    private static void checkClass(Class enumClass) {
        if (enumClass == null) {
            throw new NullPointerException("enumClass can't be null");
        }
        if (!GEnum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("GEnum subclass expected");
        }
    }

    private void registerInstance(Class enumClass) {
        String className = enumClass.getName();
        Map<Object, ? extends GEnum> classRegistry = registry.get(className);
        if (classRegistry == null) {
            classRegistry = new HashMap<Object, GEnum>();
            registry.put(className, classRegistry);
        }
        classRegistry.put(this.ordinal, this);
        classRegistry.put(this.name.toLowerCase(), this);
    }
}

